/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.impl.EObjectImpl;
import org.eclipse.edt.mof.impl.Slot;
import org.eclipse.edt.mof.utils.EList;

public class ExpressionCloner {
    private Map<Object, Object> alreadyCloned = new HashMap<Object, Object>();

    public static Expression clone(Expression expr) {
        return new ExpressionCloner().primClone(expr);
    }

    private Expression primClone(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (!(expr instanceof EObjectImpl)) {
            return expr;
        }
        EObjectImpl newExpr = (EObjectImpl)expr.getEClass().newInstance();
        Slot[] slots = ((EObjectImpl)expr).getSlots();
        int i = 0;
        while (i < slots.length && i < newExpr.getSlots().length) {
            if (slots[i] != null) {
                if (newExpr.getSlots()[i] == null) {
                    newExpr.getSlots()[i] = new Slot();
                }
                Object value = slots[i].get();
                Object newValue = this.cloneIfNeeded(value);
                newExpr.getSlots()[i].set(newValue);
            }
            ++i;
        }
        return (Expression)newExpr;
    }

    private Object cloneIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        Object newValue = this.alreadyCloned.get(value);
        if (newValue == null) {
            newValue = value instanceof Expression ? this.primClone((Expression)value) : (value instanceof EList ? this.cloneList((EList)value) : value);
            this.alreadyCloned.put(value, newValue);
        }
        return newValue;
    }

    private EList cloneList(EList list) {
        EList newList = new EList();
        for (Object obj : list) {
            newList.add(this.cloneIfNeeded(obj));
        }
        return newList;
    }
}

