/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

public class TimeStampAndIntervalPatternFixer {
    PatternEntry first;

    public TimeStampAndIntervalPatternFixer(String pattern) {
        this.first = this.parse(pattern);
    }

    private PatternEntry parse(String pattern) {
        if (pattern == null) {
            return null;
        }
        PatternEntry firstEntry = null;
        PatternEntry currentEntry = null;
        String curPattern = null;
        String curChar = null;
        String prevChar = null;
        int i = 0;
        while (i < pattern.length()) {
            curChar = pattern.substring(i, i + 1);
            if (prevChar == null) {
                curPattern = curChar;
            } else if (curChar.equalsIgnoreCase(prevChar)) {
                curPattern = String.valueOf(curPattern) + curChar;
            } else {
                PatternEntry newEntry = new PatternEntry(curPattern);
                if (firstEntry == null) {
                    firstEntry = newEntry;
                } else {
                    currentEntry.setNext(newEntry);
                    newEntry.setPrevious(currentEntry);
                }
                currentEntry = newEntry;
                curPattern = curChar;
            }
            prevChar = curChar;
            ++i;
        }
        PatternEntry newEntry = new PatternEntry(curPattern);
        if (firstEntry == null) {
            firstEntry = newEntry;
        } else {
            currentEntry.setNext(newEntry);
            newEntry.setPrevious(currentEntry);
        }
        currentEntry = newEntry;
        curPattern = "";
        return firstEntry;
    }

    public String toString() {
        if (this.first == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        PatternEntry curEntry = this.first;
        while (curEntry != null) {
            buffer.append(curEntry.toString());
            curEntry = curEntry.next;
        }
        return buffer.toString();
    }

    private static class PatternEntry {
        String value;
        PatternEntry next;
        PatternEntry previous;

        public PatternEntry(String value) {
            this.value = value;
        }

        boolean isYear() {
            return this.value.toUpperCase().toLowerCase().startsWith("y");
        }

        boolean isDay() {
            return this.value.toUpperCase().toLowerCase().startsWith("d");
        }

        boolean isMonth() {
            if (!this.value.toUpperCase().toLowerCase().startsWith("m")) {
                return false;
            }
            if (this.previous != null) {
                return this.previous.isYear();
            }
            if (this.next != null) {
                return this.next.isDay();
            }
            return this.value.startsWith("M");
        }

        boolean isHour() {
            return this.value.toUpperCase().toLowerCase().startsWith("h");
        }

        public String toString() {
            if (this.isMonth() || this.isHour()) {
                return this.value.toUpperCase();
            }
            return this.value.toLowerCase();
        }

        public void setNext(PatternEntry next) {
            this.next = next;
        }

        public void setPrevious(PatternEntry previous) {
            this.previous = previous;
        }
    }
}

