/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.rui.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.edt.rui.messages.RUIResourceKeys;

public class DateFormatAnnotationValidator
extends AnnotationValidationRule {
    public DateFormatAnnotationValidator() {
        super(NameUtile.getAsCaseSensitiveName((String)"dateformat"));
    }

    public void validate(Node errorNode, Node target, Element targetElement, Map<String, Object> allAnnotationsAndFields, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        Type type = null;
        if (targetElement instanceof Type) {
            type = (Type)targetElement;
        } else if (targetElement instanceof TypedElement) {
            type = ((TypedElement)targetElement).getType();
        }
        if (type == null) {
            return;
        }
        if (type instanceof FixedPrecisionType) {
            if (((FixedPrecisionType)type).getDecimals() > 0) {
                problemRequestor.acceptProblem(errorNode, 3175, 2, new String[]{"dateFormat"}, RUIResourceKeys.getResourceBundleForKeys());
            }
            return;
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getParameterizableType();
        }
        if (TypeUtils.Type_STRING.equals(type).booleanValue() || TypeUtils.Type_DATE.equals(type).booleanValue() || TypeUtils.isNumericType((Type)type)) {
            return;
        }
        problemRequestor.acceptProblem(errorNode, 3174, 2, new String[]{"dateFormat", BindingUtil.getShortTypeString((Type)type, (boolean)false)}, RUIResourceKeys.getResourceBundleForKeys());
    }
}

