/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.rui.validation.annotation;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.rui.messages.RUIResourceKeys;

public class DateFormatAnnotationValueValidator
implements IValueValidationRule {
    private static Set<Character> invalidDateFormatChars = new TreeSet<Character>();

    static {
        invalidDateFormatChars.add(Character.valueOf('Y'));
    }

    public void validate(Node errorNode, Node target, Annotation annotation, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotation.getValue() instanceof String) {
            String value = (String)annotation.getValue();
            try {
                char[] dateFormatPropertyValue = value.toCharArray();
                boolean validating = true;
                TreeSet<Character> markedChars = new TreeSet<Character>();
                int i = 0;
                while (i < dateFormatPropertyValue.length) {
                    char currentChar = dateFormatPropertyValue[i];
                    if (currentChar == '\'') {
                        validating = !validating;
                    } else if (validating && invalidDateFormatChars.contains(Character.valueOf(currentChar)) && !markedChars.contains(Character.valueOf(currentChar))) {
                        markedChars.add(Character.valueOf(currentChar));
                        problemRequestor.acceptProblem(errorNode, 3171, 2, new String[]{"dateFormat", "'" + currentChar + "'"}, RUIResourceKeys.getResourceBundleForKeys());
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }
}

