/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.rui.validation.annotation;

import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.edt.rui.messages.RUIResourceKeys;

public class PublishHelperValidator
implements IValueValidationRule {
    public void validate(Node errorNode, Node target, Annotation annotation, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        FunctionMember function;
        Object value = annotation.getValue(NameUtile.getAsName((String)"publishHelper"));
        if (value instanceof FunctionMember && !this.isValidPublishHelperFunction(function = (FunctionMember)value)) {
            problemRequestor.acceptProblem(errorNode, 3320, 2, new String[]{function.getCaseSensitiveName()}, RUIResourceKeys.getResourceBundleForKeys());
        }
    }

    public boolean isValidPublishHelperFunction(FunctionMember function) {
        if (function.getReturnType() != null) {
            return false;
        }
        if (function.getParameters().size() != 1) {
            return false;
        }
        FunctionParameter parm = (FunctionParameter)function.getParameters().get(0);
        if (parm.isNullable() || !TypeUtils.Type_STRING.equals(parm.getType()).booleanValue()) {
            return false;
        }
        switch (parm.getParameterKind()) {
            case PARM_INOUT: 
            case PARM_OUT: {
                return false;
            }
        }
        return true;
    }
}

