/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;

public abstract class AbstractXSLTLiaisonTest
extends TestCase {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    protected XSLTLiaison liaison;

    protected AbstractXSLTLiaisonTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.liaison = this.createLiaison();
    }

    protected abstract XSLTLiaison createLiaison() throws Exception;

    protected File getFile(String name) throws FileNotFoundException {
        URL url = ((Object)((Object)this)).getClass().getResource(name);
        if (url == null) {
            throw new FileNotFoundException("Unable to load '" + name + "' from classpath");
        }
        return new File(FILE_UTILS.fromURI(url.toExternalForm()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransform() throws Exception {
        File xsl = this.getFile("/taskdefs/optional/xsltliaison-in.xsl");
        this.liaison.setStylesheet(xsl);
        this.liaison.addParam("param", "value");
        File in = this.getFile("/taskdefs/optional/xsltliaison-in.xml");
        File out = new File("xsltliaison.tmp");
        out.deleteOnExit();
        try {
            this.liaison.transform(in, out);
        }
        finally {
            out.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncoding() throws Exception {
        File xsl = this.getFile("/taskdefs/optional/xsltliaison-encoding-in.xsl");
        this.liaison.setStylesheet(xsl);
        File in = this.getFile("/taskdefs/optional/xsltliaison-encoding-in.xml");
        File out = new File("xsltliaison-encoding.tmp");
        out.deleteOnExit();
        try {
            this.liaison.transform(in, out);
            Document doc = this.parseXML(out);
            AbstractXSLTLiaisonTest.assertEquals((String)"root", (String)doc.getDocumentElement().getNodeName());
            AbstractXSLTLiaisonTest.assertEquals((String)"message", (String)doc.getDocumentElement().getFirstChild().getNodeName());
            AbstractXSLTLiaisonTest.assertEquals((String)"\u00e9\u00e0\u00e8\u00ef\u00f9", (String)doc.getDocumentElement().getFirstChild().getFirstChild().getNodeValue());
        }
        finally {
            out.delete();
        }
    }

    public Document parseXML(File file) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbuilder = dbfactory.newDocumentBuilder();
        return dbuilder.parse(file);
    }
}

