/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUpdateSite {
    private static final List<String> EMPTY_LIST = new ArrayList<String>(0);
    private String url;
    private String featureId;
    private List<String> categories;

    public ExtensionUpdateSite() {
    }

    public ExtensionUpdateSite(String url, String featureId, List<String> categories) {
        this.url = url;
        this.featureId = featureId;
        this.categories = categories;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            return EMPTY_LIST;
        }
        return this.categories;
    }

    public List<Extension> getExtensions(IProgressMonitor monitor) throws CoreException {
        try {
            UpdateSiteMetadataRepositoryFactory mrf = new UpdateSiteMetadataRepositoryFactory();
            BundleContext bd = Activator.getDefault().getBundle().getBundleContext();
            mrf.setAgent(ExtensionUtility.getAgent(bd));
            URI url2 = new URI(this.url);
            IMetadataRepository repo = mrf.load(url2, 0, monitor);
            IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(bd, IProfileRegistry.class.getName());
            profileRegistry.getProfiles();
            profileRegistry.getProfile("_SELF_");
            IQuery query = QueryUtil.createMatchQuery((String)"id ~=/*org.eclipse.wst.server.core.serverAdapter/", (Object[])new Object[0]);
            IQueryResult collector = repo.query(query, monitor);
            ArrayList<Extension> list = new ArrayList<Extension>();
            for (IInstallableUnit iu : collector.toUnmodifiableSet()) {
                Collection req = iu.getRequirements();
                if (req == null) continue;
                for (IRequirement requirement : req) {
                    IMatchExpression matches = requirement.getMatches();
                    query = new ExpressionMatchQuery(IInstallableUnit.class, (IExpression)matches, new Object[0]);
                    IQueryResult collector2 = repo.query(query, monitor);
                    for (IInstallableUnit iu2 : collector2) {
                        if (list.contains(iu2)) continue;
                        Extension ext = new Extension(iu2, url2);
                        list.add(ext);
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting update info", e);
            return new ArrayList<Extension>(0);
        }
    }
}

