/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.EglarBuildPathEntry;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ICompilerExtension;
import org.eclipse.edt.compiler.IGenerator;
import org.eclipse.edt.compiler.MofarBuildPathEntry;
import org.eclipse.edt.compiler.SystemLibraryUtil;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;
import org.eclipse.edt.compiler.internal.util.NameUtil;
import org.eclipse.edt.mof.egl.impl.ProgramImpl;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class BaseCompiler
implements ICompiler {
    private static final String EDT_JAR_EXTENSION = ".eglar";
    private static final String EDT_MOF_EXTENSION = ".mofar";
    protected String systemEnvironmentRootPath;
    private List<ZipFileBindingBuildPathEntry> systemPathEntries;
    protected List<ICompilerExtension> extensions;
    protected Map<Class, List<ICompilerExtension>> astTypeToExtensions;
    protected String id;
    protected String name;
    protected List<IGenerator> generators = new ArrayList<IGenerator>();
    protected String version;

    public BaseCompiler() {
        this.extensions = new ArrayList<ICompilerExtension>();
        this.astTypeToExtensions = new HashMap<Class, List<ICompilerExtension>>();
    }

    @Override
    public List<ICompilerExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public void addExtension(ICompilerExtension extension) {
        if (!this.extensions.contains(extension)) {
            this.extensions.add(extension);
            Class[] types = extension.getExtendedTypes();
            if (types != null && types.length > 0) {
                int i = 0;
                while (i < types.length) {
                    List<ICompilerExtension> list = this.astTypeToExtensions.get(types[i]);
                    if (list == null) {
                        list = new ArrayList<ICompilerExtension>();
                        this.astTypeToExtensions.put(types[i], list);
                    }
                    list.add(extension);
                    ++i;
                }
            }
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name != null && name.length() == 0 ? null : name;
    }

    @Override
    public String getName() {
        return this.name == null ? this.id : this.name;
    }

    @Override
    public String getSystemEnvironmentPath() {
        if (this.systemEnvironmentRootPath == null) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(SystemLibraryUtil.getSystemLibraryPath(ProgramImpl.class, "lib"));
            for (ICompilerExtension ext : this.extensions) {
                String[] paths = ext.getSystemEnvironmentPaths();
                if (paths == null || paths.length <= 0) continue;
                int i = 0;
                while (i < paths.length) {
                    if (paths[i] != null && paths[i].trim().length() > 0) {
                        buf.append(File.pathSeparatorChar);
                        buf.append(paths[i].trim());
                    }
                    ++i;
                }
            }
            this.systemEnvironmentRootPath = buf.toString();
        }
        return this.systemEnvironmentRootPath;
    }

    @Override
    public List<IGenerator> getGenerators() {
        return this.generators;
    }

    @Override
    public void addGenerator(IGenerator generator) {
        this.generators.add(generator);
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    @Override
    public List<ASTValidator> getValidatorsFor(Node node) {
        List<ICompilerExtension> nodeExtensions = this.astTypeToExtensions.get(node.getClass());
        if (nodeExtensions != null && nodeExtensions.size() > 0) {
            ArrayList<ASTValidator> validators = new ArrayList<ASTValidator>(nodeExtensions.size() + 1);
            for (ICompilerExtension ext : nodeExtensions) {
                ASTValidator validator = ext.getValidatorFor(node);
                if (validator == null) continue;
                validators.add(validator);
                if (!(node instanceof Statement)) continue;
                return validators;
            }
            return validators;
        }
        return null;
    }

    @Override
    public ElementGenerator getElementGeneratorFor(Node node) {
        List<ICompilerExtension> nodeExtensions = this.astTypeToExtensions.get(node.getClass());
        if (nodeExtensions != null && nodeExtensions.size() > 0) {
            for (ICompilerExtension ext : nodeExtensions) {
                ElementGenerator generator = ext.getElementGeneratorFor(node);
                if (generator == null) continue;
                return generator;
            }
        }
        return null;
    }

    @Override
    public List<ZipFileBindingBuildPathEntry> getSystemBuildPathEntries() {
        return this.getSystemBuildPathEntries(this.getSystemEnvironmentPath());
    }

    public List<ZipFileBindingBuildPathEntry> getSystemBuildPathEntries(String systemEnvPath) {
        if (this.systemPathEntries == null) {
            this.systemPathEntries = new ArrayList<ZipFileBindingBuildPathEntry>();
            String[] paths = NameUtil.toStringArray(systemEnvPath, File.pathSeparator);
            Environment env = new Environment();
            Bootstrap.initialize((IEnvironment)env);
            env.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
            int i = 0;
            while (i < paths.length) {
                File libfolder = new File(paths[i]);
                if (libfolder.exists() && libfolder.isDirectory()) {
                    File[] files;
                    File[] fileArray = files = libfolder.listFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isFile()) {
                            ZipFileObjectStore store;
                            EglarBuildPathEntry entry;
                            if (file.getName().endsWith(EDT_JAR_EXTENSION)) {
                                entry = new EglarBuildPathEntry(null, file.getAbsolutePath(), ".eglxml");
                                store = new ZipFileObjectStore(file, (IEnvironment)env, "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
                                entry.setStore((ObjectStore)store);
                                env.registerObjectStore("egl", (ObjectStore)store);
                                this.systemPathEntries.add(entry);
                            } else if (file.getName().endsWith(EDT_MOF_EXTENSION)) {
                                entry = new MofarBuildPathEntry(null, file.getAbsolutePath(), ".mofxml");
                                store = new ZipFileObjectStore(file, (IEnvironment)env, "XML", ".mofxml", (IZipFileEntryManager)entry);
                                entry.setStore((ObjectStore)store);
                                env.registerObjectStore("mof", (ObjectStore)store);
                                this.systemPathEntries.add(entry);
                            }
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return this.systemPathEntries;
    }
}

