/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationValueGatherer;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.EEnum;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.utils.NameUtile;

public class AnnotationTypeValueGatherer
extends AnnotationValueGatherer {
    EField field;

    public AnnotationTypeValueGatherer(Expression expr, EField field, Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(expr, currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.field = field;
    }

    @Override
    public boolean visit(SimpleName simpleName) {
        EEnumLiteral lit;
        EEnum eenum = this.getEEnumType();
        if (eenum != null && (lit = eenum.getEEnumLiteral(simpleName.getIdentifier())) != null) {
            simpleName.setElement(lit);
            simpleName.setBindAttempted(true);
            return false;
        }
        return super.visit(simpleName);
    }

    @Override
    public boolean visit(QualifiedName qualifiedName) {
        EEnum eenum = this.getEEnumType();
        if (eenum != null) {
            EEnumLiteral lit;
            String eeName = NameUtile.getAsName((String)eenum.getName());
            String eeQualName = NameUtile.getAsName((String)eenum.getETypeSignature());
            if ((NameUtile.equals((String)eeName, (String)qualifiedName.getQualifier().getNameComponents()) || NameUtile.equals((String)eeQualName, (String)qualifiedName.getQualifier().getNameComponents())) && (lit = eenum.getEEnumLiteral(qualifiedName.getIdentifier())) != null) {
                qualifiedName.setElement(lit);
                qualifiedName.setBindAttempted(true);
                return false;
            }
        }
        return super.visit(qualifiedName);
    }

    private EEnum getEEnumType() {
        if (this.field != null) {
            EType type = this.field.getEType();
            return this.getEEnumType(type);
        }
        return null;
    }

    private EEnum getEEnumType(EType type) {
        if (type instanceof EEnum) {
            return (EEnum)type;
        }
        if (type instanceof EGenericType) {
            return this.getEEnumType((EType)((EGenericType)type).getETypeArguments().get(0));
        }
        return null;
    }

    @Override
    AnnotationValueGatherer getGatherer(Expression expr) {
        return new AnnotationTypeValueGatherer(expr, this.field, this.currentScope, this.currentBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
    }
}

