/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class HandlerBindingCompletor
extends FunctionContainerBindingCompletor {
    private Handler handlerBinding;

    public HandlerBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(irBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.handlerBinding = (Handler)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Handler handler) {
        handler.getName().setType((Type)this.handlerBinding);
        handler.accept(this.getPartSubTypeAndAnnotationCollector());
        if (handler.isPrivate()) {
            this.handlerBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        for (Name nextName : handler.getImplementedInterfaces()) {
            try {
                Type typeBinding = this.bindTypeName(nextName);
                if (!(typeBinding instanceof StructPart)) continue;
                this.handlerBinding.getSuperTypes().add((StructPart)typeBinding);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        this.setDefaultSuperType();
        return true;
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.Handler handler) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(handler);
    }

    @Override
    protected StereotypeType getDefaultStereotypeType() {
        try {
            return (StereotypeType)BindingUtil.getAnnotationType(NameUtile.getAsName((String)"eglx.lang"), NameUtile.getAsName((String)"BasicHandler"));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

