/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.utils.NameUtile;

public class PackageBinding
extends Binding
implements IPackageBinding {
    private PackageBinding parent;
    private IEnvironment environment;
    private PackageBinding[] subPackages;
    private String packageName;
    private String caseSensitivePackageName;

    public PackageBinding(String caseSensitivePackageName, PackageBinding parent, IEnvironment environment) {
        super(BindingUtil.getLastSegment(caseSensitivePackageName));
        this.caseSensitivePackageName = caseSensitivePackageName;
        this.parent = parent;
        this.environment = environment;
    }

    @Override
    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = NameUtile.getAsName((String)this.getCaseSensitivePackageName());
        }
        return this.packageName;
    }

    @Override
    public String getCaseSensitivePackageName() {
        return this.caseSensitivePackageName;
    }

    public PackageBinding getParent() {
        return this.parent;
    }

    private PackageBinding addPackage(String packageName) {
        PackageBinding packageBinding = new PackageBinding(packageName, this, this.environment);
        if (this.subPackages == null) {
            this.subPackages = new PackageBinding[]{packageBinding};
        } else {
            PackageBinding[] newSubPackages = new PackageBinding[this.subPackages.length + 1];
            System.arraycopy(this.subPackages, 0, newSubPackages, 0, this.subPackages.length);
            newSubPackages[this.subPackages.length] = packageBinding;
            this.subPackages = newSubPackages;
        }
        return packageBinding;
    }

    @Override
    public IPackageBinding resolvePackage(String simpleName) {
        String subPackageName;
        if (this.subPackages != null) {
            int i = 0;
            while (i < this.subPackages.length) {
                if (NameUtile.equals((String)this.subPackages[i].getName(), (String)simpleName)) {
                    return this.subPackages[i];
                }
                ++i;
            }
        }
        if (this.environment.hasPackage(NameUtile.getAsName((String)(subPackageName = this.getPackageName().length() > 0 ? String.valueOf(this.getCaseSensitivePackageName()) + "." + simpleName : simpleName)))) {
            return this.addPackage(subPackageName);
        }
        return null;
    }

    @Override
    public IPartBinding resolveType(String simpleName) {
        return this.environment.getPartBinding(this.getPackageName(), simpleName);
    }

    @Override
    public boolean isPackageBinding() {
        return true;
    }
}

