/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.Type;

public class PartSubTypeAndAnnotationCollector
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private List<SettingsBlock> settingsBlocks = new ArrayList<SettingsBlock>();
    private Stereotype stereotype;
    private Part partBinding;
    private boolean foundSubTypeInSettingsBlock = false;
    private AbstractBinder abstractBinder;

    public PartSubTypeAndAnnotationCollector(Part partBinding, AbstractBinder binder, IProblemRequestor problemRequestor) {
        this.partBinding = partBinding;
        this.abstractBinder = binder;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        this.settingsBlocks.add(settingsBlock);
        settingsBlock.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                return true;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                AnnotationType annType;
                Type resolvedType = null;
                try {
                    resolvedType = PartSubTypeAndAnnotationCollector.this.abstractBinder.bindTypeName(annotationExpression.getName());
                }
                catch (ResolutionException resolutionException) {
                    resolvedType = null;
                }
                annotationExpression.getName().setElement(null);
                annotationExpression.getName().setType(null);
                annotationExpression.getName().setBindAttempted(false);
                StereotypeType stereotypeType = null;
                if (resolvedType != null && (annType = BindingUtil.getAnnotationType(resolvedType)) instanceof StereotypeType) {
                    stereotypeType = (StereotypeType)annType;
                }
                if (stereotypeType != null) {
                    if (BindingUtil.isApplicableFor(stereotypeType, (Element)PartSubTypeAndAnnotationCollector.this.partBinding)) {
                        if (PartSubTypeAndAnnotationCollector.this.stereotype == null) {
                            PartSubTypeAndAnnotationCollector.this.stereotype = (Stereotype)stereotypeType.newInstance();
                            PartSubTypeAndAnnotationCollector.this.foundSubTypeInSettingsBlock = true;
                            annotationExpression.getName().setElement(PartSubTypeAndAnnotationCollector.this.stereotype);
                            annotationExpression.getName().setType((Type)stereotypeType);
                            annotationExpression.setType((Type)stereotypeType);
                        } else {
                            PartSubTypeAndAnnotationCollector.this.problemRequestor.acceptProblem(annotationExpression.getName(), 2056);
                        }
                    } else {
                        PartSubTypeAndAnnotationCollector.this.problemRequestor.acceptProblem((Node)annotationExpression.getName(), 2057, new String[]{annotationExpression.getName().getCanonicalName(), PartSubTypeAndAnnotationCollector.this.partBinding.getCaseSensitiveName()});
                    }
                }
                return false;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }
        });
        return false;
    }

    @Override
    public boolean visit(Record record) {
        if (record.hasSubType()) {
            this.checkSubType(record.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Program program) {
        if (program.hasSubType()) {
            this.checkSubType(program.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Library library) {
        if (library.hasSubType()) {
            this.checkSubType(library.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Service service) {
        if (service.hasSubType()) {
            this.checkSubType(service.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Interface intrface) {
        if (intrface.hasSubType()) {
            this.checkSubType(intrface.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(ExternalType externalType) {
        if (externalType.hasSubType()) {
            this.checkSubType(externalType.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Handler handler) {
        if (handler.hasSubType()) {
            this.checkSubType(handler.getSubType());
        }
        return true;
    }

    @Override
    public boolean visit(Class eglClass) {
        if (eglClass.hasSubType()) {
            this.checkSubType(eglClass.getSubType());
        }
        return true;
    }

    private void checkSubType(Name name) {
        AnnotationType annType;
        StereotypeType stereotypeType = null;
        Type resolvedType = null;
        boolean typeResolved = false;
        try {
            resolvedType = this.abstractBinder.bindTypeName(name);
            typeResolved = true;
        }
        catch (ResolutionException resolutionException) {
            resolvedType = null;
        }
        if (resolvedType != null && (annType = BindingUtil.getAnnotationType(resolvedType)) instanceof StereotypeType) {
            stereotypeType = (StereotypeType)annType;
        }
        if (stereotypeType == null || !BindingUtil.isApplicableFor(stereotypeType, (Element)this.partBinding)) {
            if (typeResolved) {
                this.problemRequestor.acceptProblem((Node)name, 2057, new String[]{name.getCanonicalName(), this.partBinding.getCaseSensitiveName()});
            } else {
                this.problemRequestor.acceptProblem((Node)name, 3260, new String[]{name.getCanonicalName()});
            }
            name.setBindAttempted(true);
        } else {
            this.stereotype = (Stereotype)stereotypeType.newInstance();
            this.partBinding.addAnnotation((Annotation)this.stereotype);
            name.setType((Type)stereotypeType);
            name.setElement(this.stereotype);
        }
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public boolean isFoundSubTypeInSettingsBlock() {
        return this.foundSubTypeInSettingsBlock;
    }

    public List<SettingsBlock> getSettingsBlocks() {
        return this.settingsBlocks;
    }
}

