/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.MemberScope;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.RecordScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;

public class RecordBindingFieldsCompletor
extends AbstractBinder {
    private Record recordBinding;
    private String canonicalRecordName;
    private IProblemRequestor problemRequestor;
    private Set<String> definedNames = new HashSet<String>();

    public RecordBindingFieldsCompletor(Scope currentScope, Record recordBinding, String canonicalRecordName, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, (Part)recordBinding, dependencyRequestor, compilerOptions);
        this.recordBinding = recordBinding;
        this.canonicalRecordName = canonicalRecordName;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
        return true;
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.Record record) {
        AbstractASTVisitor visitor = new AbstractASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasSettingsBlock()) {
                    Field field = null;
                    if (structureItem.getName() != null) {
                        field = (Field)structureItem.getName().resolveMember();
                    }
                    if (field != null) {
                        final Field fld = field;
                        DefaultASTVisitor sbVisitor = new DefaultASTVisitor(){

                            @Override
                            public boolean visit(SettingsBlock settingsBlock) {
                                MemberScope fieldScope = new MemberScope(NullScope.INSTANCE, (Member)fld);
                                AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(fieldScope, (Element)fld, fld.getType(), (Element)fld);
                                settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(new RecordScope(RecordBindingFieldsCompletor.this.currentScope, RecordBindingFieldsCompletor.this.recordBinding), (Part)RecordBindingFieldsCompletor.this.recordBinding, annotationScope, RecordBindingFieldsCompletor.this.dependencyRequestor, RecordBindingFieldsCompletor.this.problemRequestor, RecordBindingFieldsCompletor.this.compilerOptions));
                                return false;
                            }
                        };
                        structureItem.getSettingsBlock().accept(sbVisitor);
                    }
                }
                return false;
            }
        };
        record.accept(visitor);
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        Type type = null;
        try {
            type = this.bindType(structureItem.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            if (structureItem.hasSettingsBlock()) {
                RecordBindingFieldsCompletor.setBindAttemptedForNames(structureItem.getSettingsBlock());
            }
            return false;
        }
        Field fieldBinding = this.createField(structureItem, type);
        if (this.definedNames.contains(fieldBinding.getName())) {
            this.problemRequestor.acceptProblem((Node)structureItem.getName(), 3010, new String[]{structureItem.getName().getCanonicalName(), this.canonicalRecordName});
        } else {
            this.definedNames.add(fieldBinding.getName());
            this.recordBinding.getFields().add(fieldBinding);
        }
        return false;
    }

    public Field createField(StructureItem structureItem, Type type) {
        String fieldName = structureItem.getName().getCaseSensitiveIdentifier();
        Field field = IrFactory.INSTANCE.createField();
        field.setName(fieldName);
        field.setContainer((Container)this.recordBinding);
        field.setType(type);
        field.setIsNullable(structureItem.isNullable());
        structureItem.getName().setMember((Member)field);
        structureItem.getName().setType(type);
        return field;
    }
}

