/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Type;

public class ArrayType
extends Type {
    private Type elementType;
    private Expression initialSize;
    private org.eclipse.edt.mof.egl.ArrayType arrayType;
    private boolean isNullable;

    public ArrayType(Type elementType, Expression initialSize, boolean isNullable, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.elementType = elementType;
        elementType.setParent(this);
        if (initialSize != null) {
            this.initialSize = initialSize;
            this.initialSize.setParent(this);
        }
        this.isNullable = isNullable;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public boolean hasInitialSize() {
        return this.initialSize != null;
    }

    public Expression getInitialSize() {
        return this.initialSize;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public org.eclipse.edt.mof.egl.Type resolveType() {
        return this.arrayType;
    }

    public void setType(org.eclipse.edt.mof.egl.ArrayType arrayType) {
        this.arrayType = arrayType;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.elementType.accept(visitor);
            if (this.initialSize != null) {
                this.initialSize.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.elementType.getCanonicalName());
        if (this.isNullable) {
            buf.append('?');
        }
        buf.append('[');
        if (this.initialSize != null) {
            buf.append(this.initialSize.getCanonicalString());
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression newInitialSize = this.initialSize != null ? (Expression)this.initialSize.clone() : null;
        return new ArrayType((Type)this.elementType.clone(), newInitialSize, this.isNullable, this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public Type getBaseType() {
        return this.elementType.getBaseType();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

