/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ObjectExpressionEntry;

public class ObjectExpression
extends Expression {
    private List entries;

    public ObjectExpression(List entries, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.entries = this.setParent(entries);
    }

    public List getEntries() {
        return this.entries;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            ObjectExpression.acceptChildren(visitor, this.entries);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Iterator iter = this.getEntries().iterator();
        while (iter.hasNext()) {
            result.append(((ObjectExpressionEntry)iter.next()).getCanonicalString());
            if (!iter.hasNext()) continue;
            result.append(",");
        }
        result.append("}");
        return result.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ObjectExpression(this.cloneList(this.entries), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return this.getCanonicalString();
    }
}

