/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.mof.egl.Member;

public class StructureItem
extends Node {
    private SimpleName name;
    private Type type;
    private boolean isNullable;
    private SettingsBlock settingsBlockOpt;
    private Expression initializerOpt;
    private Member member;

    public StructureItem(SimpleName name, Type type, Boolean isNullable, SettingsBlock settingsBlockOpt, Expression initializerOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (name != null) {
            this.name = name;
            name.setParent(this);
        }
        if (type != null) {
            this.type = type;
            type.setParent(this);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        if (initializerOpt != null) {
            this.initializerOpt = initializerOpt;
            initializerOpt.setParent(this);
        }
        this.isNullable = isNullable;
    }

    public Name getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public boolean hasInitializer() {
        return this.initializerOpt != null;
    }

    public Expression getInitializer() {
        return this.initializerOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.name != null) {
                this.name.accept(visitor);
            }
            if (this.type != null) {
                this.type.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            if (this.initializerOpt != null) {
                this.initializerOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SimpleName newName = this.name != null ? (SimpleName)this.name.clone() : null;
        Type newType = this.type != null ? (Type)this.type.clone() : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        Expression newInitializerOpt = this.initializerOpt != null ? (Expression)this.initializerOpt.clone() : null;
        return new StructureItem(newName, newType, this.isNullable, newSettingsBlockOpt, newInitializerOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        if (this.name != null) {
            buf.append(this.name);
            buf.append(' ');
        }
        if (this.type != null) {
            buf.append(this.type.toString());
        }
        if (this.settingsBlockOpt != null) {
            buf.append(this.settingsBlockOpt.toString());
        }
        if (this.initializerOpt != null) {
            buf.append(" = ");
            buf.append(this.initializerOpt.toString());
        }
        buf.append(';');
        return buf.toString();
    }
}

