/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class TerminalSubstitutionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int substitutionTerminal;

    public TerminalSubstitutionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        short[] terminalCandidates = this.errorStack.getTerminalCandidates(this.errorStack.getCurrentState());
        int i = 0;
        while (i < terminalCandidates.length) {
            if (terminalCandidates[i] != 59) {
                Terminal terminal = new Terminal(terminalCandidates[i], -1, -1, -1);
                ParseStack trialStack = this.errorStack.createCopy();
                ITokenStream trialStream = this.tokenStream.createTokenStreamAtOffset(1);
                trialStack.processLookAhead(terminal);
                int trialDistance = trialStack.parseCheck(trialStream);
                if (trialDistance > this.parseCheckDistance) {
                    this.parseCheckDistance = trialDistance;
                    this.substitutionTerminal = terminalCandidates[i];
                }
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance + 1;
    }

    @Override
    public int performRecovery() {
        int errorStart = this.tokenStream.getLookAhead().left;
        int errorEnd = this.tokenStream.getLookAhead().right;
        int errorNodeType = this.tokenStream.peekLookAhead((int)0).symbolType;
        Terminal terminal = new Terminal(this.substitutionTerminal, errorStart, errorEnd, -1);
        Symbol symbol = new Symbol(this.substitutionTerminal, errorStart, errorEnd);
        symbol.parse_state = -2;
        this.tokenStream.advanceLookAhead();
        this.tokenStream.rollBack(terminal, symbol);
        if ((99 == terminal.symbolType || 35 == terminal.symbolType) && EGLKeywordHandler.getKeywordHashSet().contains(NodeNameUtility.getTerminalName(errorNodeType).toLowerCase()) && errorNodeType != 103) {
            this.problemRequestor.keywordAsName(errorNodeType, errorStart, errorEnd);
        } else {
            this.problemRequestor.incorrectTerminal(this.substitutionTerminal, errorStart, errorEnd);
        }
        return 0;
    }
}

