/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class UnaryExpression
extends Expression {
    private Operator operator;
    private Expression expr;

    public UnaryExpression(Operator operator, Expression expr, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.operator = operator;
        this.expr = expr;
        expr.setParent(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public String getCanonicalString() {
        StringBuffer result = new StringBuffer();
        if (this.operator != Operator.PLUS) {
            result.append(this.operator.token);
        }
        result.append(this.expr.getCanonicalString());
        return result.toString();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new UnaryExpression(this.operator, (Expression)this.expr.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return String.valueOf(this.operator.toString()) + this.expr.toString();
    }

    public static class Operator {
        private String token;
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator BANG = new Operator("!");
        public static final Operator NEGATE = new Operator("~");
        private static final Map CODES = new HashMap(4);

        static {
            Operator[] ops = new Operator[]{PLUS, MINUS, BANG, NEGATE};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

