/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.BytesLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ObjectExpression;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SQLLiteral;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.TernaryExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.TypeLiteralExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.TypeScope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.SubType;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public abstract class DefaultBinder
extends AbstractBinder {
    protected IProblemRequestor problemRequestor;
    private boolean bindingFunctionInvocationTarget;

    public DefaultBinder(Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, currentBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(QualifiedName qualifiedName) {
        if (!qualifiedName.isBindAttempted()) {
            try {
                this.bindExpressionName(qualifiedName, this.bindingFunctionInvocationTarget);
            }
            catch (ResolutionException e) {
                qualifiedName.setBindAttempted(true);
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return false;
    }

    protected void handleNameResolutionException(ResolutionException e) {
        this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
    }

    @Override
    public boolean visit(SimpleName simpleName) {
        if (!simpleName.isBindAttempted()) {
            try {
                this.bindExpressionName(simpleName, this.bindingFunctionInvocationTarget);
            }
            catch (ResolutionException e) {
                this.handleNameResolutionException(e);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        this.bindingFunctionInvocationTarget = true;
        functionInvocation.getTarget().accept(this);
        this.bindingFunctionInvocationTarget = false;
        for (Expression expr : functionInvocation.getArguments()) {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SuperExpression superExpression) {
        SubType sub;
        Part part;
        if (superExpression.isBindAttempted()) {
            return false;
        }
        Scope scopeForThis = this.currentScope.getScopeForKeywordThis();
        if (scopeForThis instanceof FunctionContainerScope && (part = ((FunctionContainerScope)scopeForThis).getPart()) instanceof SubType && (sub = (SubType)part).getSuperTypes().size() > 0) {
            superExpression.setType((org.eclipse.edt.mof.egl.Type)sub.getSuperTypes().get(0));
            return false;
        }
        superExpression.setBindAttempted(true);
        this.problemRequestor.acceptProblem((Node)superExpression, 6619, new String[]{superExpression.getCanonicalString()});
        return false;
    }

    @Override
    public boolean visit(ThisExpression thisExpression) {
        if (thisExpression.isBindAttempted()) {
            return false;
        }
        Scope scopeForThis = this.currentScope.getScopeForKeywordThis();
        if (scopeForThis instanceof FunctionContainerScope) {
            thisExpression.setType((org.eclipse.edt.mof.egl.Type)((FunctionContainerScope)scopeForThis).getPart());
        } else {
            thisExpression.setBindAttempted(true);
            this.problemRequestor.acceptProblem((Node)thisExpression, 6619, new String[]{thisExpression.getCanonicalString()});
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteralExpression typeLiteralExpression) {
        try {
            this.bindType(typeLiteralExpression.getType());
        }
        catch (ResolutionException e) {
            this.handleNameResolutionException(e);
        }
        return false;
    }

    @Override
    public boolean visit(ArrayAccess arrayAccess) {
        return true;
    }

    @Override
    public void endVisit(ArrayAccess arrayAccess) {
        if (arrayAccess.isBindAttempted()) {
            return;
        }
        org.eclipse.edt.mof.egl.Type type = arrayAccess.getArray().resolveType();
        if (type == null) {
            arrayAccess.setBindAttempted(true);
        } else if (type instanceof org.eclipse.edt.mof.egl.ArrayType) {
            arrayAccess.setType(((org.eclipse.edt.mof.egl.ArrayType)type).getElementType());
        } else if (BindingUtil.isDynamicallyAccessible(type)) {
            arrayAccess.setType((org.eclipse.edt.mof.egl.Type)BindingUtil.getEAny());
            arrayAccess.setMember(BindingUtil.createDynamicAccessMember(type, arrayAccess.getIndices().get(0).getCanonicalString()));
        } else {
            arrayAccess.setBindAttempted(true);
        }
    }

    @Override
    public void endVisit(SubstringAccess substringAccess) {
        org.eclipse.edt.mof.egl.Type type = substringAccess.getPrimary().resolveType();
        if (type == null) {
            substringAccess.setBindAttempted(true);
        } else {
            Operation op = IRUtils.getOperation((Classifier)type.getClassifier(), (String)"[:");
            if (op == null) {
                substringAccess.setBindAttempted(true);
            } else {
                substringAccess.setType(op.getType());
            }
        }
    }

    @Override
    public void endVisit(FieldAccess fieldAccess) {
        Member member;
        if (fieldAccess.isBindAttempted()) {
            return;
        }
        org.eclipse.edt.mof.egl.Type type = fieldAccess.getPrimary().resolveType();
        if (type == null) {
            fieldAccess.setBindAttempted(true);
            return;
        }
        List<Member> mbrs = this.findData(type, fieldAccess.getID());
        if (mbrs == null && (member = BindingUtil.createExplicitDynamicAccessMember(type, fieldAccess.getCaseSensitiveID())) != null) {
            fieldAccess.setMember(member);
            fieldAccess.setType(member.getType());
            return;
        }
        if (mbrs == null) {
            int endOffset = fieldAccess.getOffset() + fieldAccess.getLength();
            this.problemRequestor.acceptProblem(endOffset - fieldAccess.getID().length(), endOffset, 6619, new String[]{fieldAccess.getCanonicalString()});
            fieldAccess.setBindAttempted(true);
            return;
        }
        if (mbrs.size() > 1) {
            if (!this.isFunctionSet(mbrs) || !this.isFunctionInvocationTarget(fieldAccess)) {
                this.problemRequestor.acceptProblem((Node)fieldAccess, 6620, new String[]{fieldAccess.getCanonicalString()});
                fieldAccess.setBindAttempted(true);
                return;
            }
            fieldAccess.setElement(mbrs);
            return;
        }
        member = mbrs.get(0);
        fieldAccess.setMember(member);
        org.eclipse.edt.mof.egl.Type mbrType = BindingUtil.getType(mbrs.get(0));
        fieldAccess.setType(mbrType);
        this.dependencyRequestor.recordType(mbrType);
    }

    private boolean isFunctionInvocationTarget(Expression expr) {
        if (expr.getParent() instanceof FunctionInvocation) {
            return ((FunctionInvocation)expr.getParent()).getTarget() == expr;
        }
        if (expr.getParent() instanceof ParenthesizedExpression) {
            return this.isFunctionInvocationTarget((ParenthesizedExpression)expr.getParent());
        }
        return false;
    }

    @Override
    public void endVisit(SimpleName simpleName) {
    }

    @Override
    public void endVisit(QualifiedName qualifiedName) {
    }

    @Override
    public boolean visit(OpenStatement openStatement) {
        return true;
    }

    @Override
    public void endVisit(OpenStatement openStatement) {
    }

    @Override
    public boolean visit(GetByKeyStatement openStatement) {
        return true;
    }

    @Override
    public void endVisit(GetByKeyStatement getByKeyStatement) {
    }

    @Override
    public void endVisit(DeleteStatement getByKeyStatement) {
    }

    @Override
    public boolean visit(GetByPositionStatement openStatement) {
        return true;
    }

    @Override
    public void endVisit(GetByPositionStatement openStatement) {
    }

    @Override
    public void endVisit(AddStatement openStatement) {
    }

    @Override
    public void endVisit(ReplaceStatement openStatement) {
    }

    @Override
    public boolean visit(ExecuteStatement openStatement) {
        return true;
    }

    @Override
    public void endVisit(ExecuteStatement openStatement) {
    }

    @Override
    public boolean visit(IntoClause intoClause) {
        return true;
    }

    @Override
    public void endVisit(IntoClause intoClause) {
    }

    @Override
    public boolean visit(IsAExpression isAExpression) {
        isAExpression.getExpression().accept(this);
        try {
            Type typeAST = isAExpression.getType();
            this.bindType(typeAST);
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
        }
        return false;
    }

    @Override
    public boolean visit(AsExpression asExpression) {
        asExpression.getExpression().accept(this);
        try {
            if (asExpression.hasType()) {
                Type typeAST = asExpression.getType();
                this.bindType(typeAST);
            }
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
        }
        return false;
    }

    public static NamedElement getOperandType(Expression expr) {
        if (expr instanceof FunctionInvocation) {
            if (expr.resolveType() != null) {
                return expr.resolveType().getClassifier();
            }
            return null;
        }
        Object element = expr.resolveElement();
        if (element instanceof Function) {
            return (Function)element;
        }
        org.eclipse.edt.mof.egl.Type type = expr.resolveType();
        if (type != null) {
            return type.getClassifier();
        }
        return null;
    }

    @Override
    public boolean visit(NewExpression newExpression) {
        NameType nameType;
        Object type;
        try {
            if (!newExpression.isBindAttempted()) {
                newExpression.setType(this.bindType(newExpression.getType(), true));
            }
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            newExpression.setBindAttempted(true);
        }
        if (newExpression.hasSettingsBlock() && (type = newExpression.resolveType()) != null) {
            TypeScope newScope = new TypeScope(NullScope.INSTANCE, (org.eclipse.edt.mof.egl.Type)type);
            newExpression.getSettingsBlock().accept(new SetValuesExpressionCompletor(this.currentScope, this.currentBinding, newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        }
        type = newExpression.getType();
        while (type != null && ((Type)type).isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            if (arrayType.hasInitialSize()) {
                arrayType.getInitialSize().accept(this);
            }
            type = arrayType.getElementType();
        }
        if (newExpression.getType().getBaseType() instanceof NameType && (nameType = (NameType)newExpression.getType().getBaseType()).hasArguments()) {
            for (Expression expr : nameType.getArguments()) {
                expr.accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(NewExpression newExpression) {
        org.eclipse.edt.mof.egl.Type targetType = newExpression.getType().resolveType();
        if (targetType != null) {
            if (targetType.getClassifier() instanceof EGLClass) {
                List<Constructor> constructors = this.getConstructors(targetType);
                if (newExpression.getType() instanceof NameType) {
                    ((NameType)newExpression.getType()).getName().setAttribute(Name.OVERLOADED_FUNCTION_SET, constructors);
                }
            }
            if (!BindingUtil.isParameterizableType(targetType) && newExpression.getType() instanceof NameType && ((NameType)newExpression.getType()).hasArguments()) {
                List<Expression> arguments = ((NameType)newExpression.getType()).getArguments();
                Constructor cons = null;
                if (targetType.getClassifier() instanceof EGLClass) {
                    cons = IRUtils.resolveConstructorReferenceFromArgTypes((EGLClass)((EGLClass)targetType.getClassifier()), this.getArgumentTypes(arguments), (boolean)false);
                }
                if (cons == null) {
                    if (arguments.size() > 0) {
                        this.problemRequestor.acceptProblem((Node)newExpression.getType(), 7830, new String[]{newExpression.getType().getCanonicalName()});
                    }
                } else {
                    newExpression.setConstructor(cons);
                    if (BindingUtil.isPrivate(cons) && !targetType.equals((org.eclipse.edt.mof.egl.Type)this.currentScope.getPart()).booleanValue()) {
                        this.problemRequestor.acceptProblem((Node)newExpression.getType(), 3434, new String[]{newExpression.getType().getCanonicalName()});
                    }
                }
            }
        }
    }

    private List<NamedElement> getArgumentTypes(List<Expression> functionArguments) {
        ArrayList<NamedElement> list = new ArrayList<NamedElement>();
        for (Expression expr : functionArguments) {
            list.add(DefaultBinder.getOperandType(expr));
        }
        return list;
    }

    private List<Constructor> getConstructors(org.eclipse.edt.mof.egl.Type type) {
        if (type instanceof StructPart) {
            return ((StructPart)type).getConstructors();
        }
        return null;
    }

    @Override
    public boolean visit(CloseStatement closeStatement) {
        IProblemRequestor pRequestor = this.problemRequestor;
        this.problemRequestor = NullProblemRequestor.getInstance();
        closeStatement.getExpr().accept(this);
        this.problemRequestor = pRequestor;
        return false;
    }

    @Override
    public boolean visit(IsNotExpression isNotExpression) {
        isNotExpression.getFirstExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(ReturningToNameClause returningToNameClause) {
        try {
            this.bindTypeName(returningToNameClause.getName());
        }
        catch (ResolutionException resolutionException) {}
        return false;
    }

    @Override
    public boolean visit(ForwardStatement forwardStatement) {
        if (forwardStatement.hasForwardTarget()) {
            Expression expr = forwardStatement.getForwardTarget();
            if (forwardStatement.isForwardToURL()) {
                expr.accept(this);
            } else {
                this.bindInvocationTarget(expr);
            }
        }
        for (Node arg : forwardStatement.getArguments()) {
            arg.accept(this);
        }
        for (Node opt : forwardStatement.getForwardOptions()) {
            opt.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(ParenthesizedExpression parenthesizedExpression) {
        parenthesizedExpression.setType(parenthesizedExpression.getExpression().resolveType());
    }

    @Override
    public void endVisit(UnaryExpression unaryExpression) {
        Expression operand = unaryExpression.getExpression();
        org.eclipse.edt.mof.egl.Type operandType = operand.resolveType();
        if (operandType == null) {
            unaryExpression.setBindAttempted(true);
        } else {
            Operation op = IRUtils.getUnaryOperation((Classifier)operandType.getClassifier(), (String)unaryExpression.getOperator().toString());
            if (op == null) {
                unaryExpression.setBindAttempted(true);
            } else {
                unaryExpression.setType(op.getType());
            }
        }
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression) {
        Operation op;
        Expression operand1 = binaryExpression.getFirstExpression();
        Expression operand2 = binaryExpression.getSecondExpression();
        NamedElement elem1 = DefaultBinder.getOperandType(operand1);
        NamedElement elem2 = DefaultBinder.getOperandType(operand2);
        if (elem1 != null && elem2 != null && (op = IRUtils.getBinaryOperation((NamedElement)elem1, (NamedElement)elem2, (String)binaryExpression.getOperator().toString())) != null) {
            binaryExpression.setType(op.getType());
        }
    }

    @Override
    public void endVisit(TernaryExpression ternaryExpression) {
        org.eclipse.edt.mof.egl.Type secondType = ternaryExpression.getSecondExpr().resolveType();
        org.eclipse.edt.mof.egl.Type thirdType = ternaryExpression.getThirdExpr().resolveType();
        if (secondType != null && thirdType != null) {
            ternaryExpression.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getCommonSupertype((org.eclipse.edt.mof.egl.Type)secondType, (org.eclipse.edt.mof.egl.Type)thirdType));
        } else if (!(secondType == null && ternaryExpression.getSecondExpr().resolveMember() == null || thirdType == null && ternaryExpression.getThirdExpr().resolveMember() == null)) {
            ternaryExpression.setType(TypeUtils.Type_ANY);
        } else {
            ternaryExpression.setBindAttempted(true);
        }
    }

    @Override
    public void endVisit(Assignment assignment) {
    }

    @Override
    public void endVisit(IsAExpression isAExpression) {
        isAExpression.setType(TypeUtils.Type_BOOLEAN);
    }

    @Override
    public void endVisit(AsExpression asExpression) {
        if (asExpression.hasType()) {
            org.eclipse.edt.mof.egl.Type type = asExpression.getType().resolveType();
            if (type == null) {
                asExpression.setBindAttempted(true);
            } else {
                asExpression.setType(type);
            }
        }
    }

    @Override
    public void endVisit(IsNotExpression isNotExpression) {
        isNotExpression.setType(TypeUtils.Type_BOOLEAN);
    }

    @Override
    public void endVisit(IntegerLiteral integerLiteral) {
        if (!integerLiteral.isBindAttempted()) {
            switch (integerLiteral.getLiteralKind()) {
                case 14: {
                    integerLiteral.setType(TypeUtils.Type_BIGINT);
                    break;
                }
                case 13: {
                    integerLiteral.setType(TypeUtils.Type_SMALLINT);
                    break;
                }
                default: {
                    integerLiteral.setType(TypeUtils.Type_INT);
                }
            }
        }
    }

    @Override
    public void endVisit(DecimalLiteral decimalLiteral) {
        if (!decimalLiteral.isBindAttempted()) {
            int len = decimalLiteral.getValue().length();
            int dec = len - (decimalLiteral.getValue().indexOf(46) + 1);
            decimalLiteral.setType(IRUtils.getEGLType((String)"eglx.lang.EDecimal", (int)(len - 1), (int)dec));
        }
    }

    @Override
    public void endVisit(FloatLiteral floatLiteral) {
        if (!floatLiteral.isBindAttempted()) {
            if (floatLiteral.getLiteralKind() == 15) {
                floatLiteral.setType(TypeUtils.Type_SMALLFLOAT);
            } else {
                floatLiteral.setType(TypeUtils.Type_FLOAT);
            }
        }
    }

    @Override
    public void endVisit(BooleanLiteral booleanLiteral) {
        if (!booleanLiteral.isBindAttempted()) {
            booleanLiteral.setType(TypeUtils.Type_BOOLEAN);
        }
    }

    @Override
    public void endVisit(StringLiteral stringLiteral) {
        if (!stringLiteral.isBindAttempted()) {
            stringLiteral.setType(IRUtils.getEGLType((String)"eglx.lang.EString", (int)stringLiteral.getValue().length()));
        }
    }

    @Override
    public void endVisit(BytesLiteral bytesLiteral) {
        if (!bytesLiteral.isBindAttempted()) {
            bytesLiteral.setType(IRUtils.getEGLType((String)"eglx.lang.EBytes", (int)(bytesLiteral.getValue().length() / 2)));
        }
    }

    @Override
    public void endVisit(SQLLiteral sqlLiteral) {
    }

    @Override
    public void endVisit(TypeLiteralExpression typeLiteralExpression) {
    }

    @Override
    public void endVisit(ObjectExpression objExpr) {
        if (!objExpr.isBindAttempted()) {
            objExpr.setType(TypeUtils.Type_ANY);
        }
    }

    private org.eclipse.edt.mof.egl.Type getCommonElementType(ArrayLiteral arrayLiteral) {
        if (arrayLiteral.getExpressions().isEmpty()) {
            return null;
        }
        org.eclipse.edt.mof.egl.Type elemType = null;
        for (Expression exp : arrayLiteral.getExpressions()) {
            if (exp.resolveMember() instanceof Function) {
                return null;
            }
            org.eclipse.edt.mof.egl.Type type = exp.resolveType();
            if (type == null) {
                return null;
            }
            if (elemType == null) {
                elemType = type;
                continue;
            }
            if (exp instanceof org.eclipse.edt.mof.egl.NullLiteral || elemType.equals(type).booleanValue() || (elemType = IRUtils.getCommonSupertype((org.eclipse.edt.mof.egl.Type)elemType, (org.eclipse.edt.mof.egl.Type)type)) != null) continue;
            return null;
        }
        return elemType;
    }

    private boolean containsNull(ArrayLiteral arrayLiteral) {
        for (Expression exp : arrayLiteral.getExpressions()) {
            if (!(exp instanceof NullLiteral)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endVisit(ArrayLiteral arrayLiteral) {
        if (!arrayLiteral.isBindAttempted()) {
            org.eclipse.edt.mof.egl.Type elemType = this.getCommonElementType(arrayLiteral);
            if (elemType == null) {
                elemType = TypeUtils.Type_NULLTYPE;
            }
            arrayLiteral.setType((org.eclipse.edt.mof.egl.Type)BindingUtil.getArrayType(elemType, this.containsNull(arrayLiteral)));
        }
    }

    @Override
    public void endVisit(NullLiteral nilLiteral) {
        if (!nilLiteral.isBindAttempted()) {
            nilLiteral.setType(TypeUtils.Type_NULLTYPE);
        }
    }

    @Override
    public void endVisit(AnnotationExpression annotationExpression) {
        annotationExpression.setType(annotationExpression.getName().resolveType());
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        setValuesExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Type type = setValuesExpression.getExpression().resolveType();
        if (type != null) {
            TypeScope newScope = new TypeScope(NullScope.INSTANCE, type);
            setValuesExpression.getSettingsBlock().accept(new SetValuesExpressionCompletor(this.currentScope, this.currentBinding, newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        } else if (setValuesExpression.getExpression().resolveElement() != null) {
            setValuesExpression.getSettingsBlock().accept(this);
        }
        return true;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        return true;
    }

    @Override
    public void endVisit(FunctionInvocationStatement functionInvocationStatement) {
    }

    @Override
    public void endVisit(FunctionInvocation functionInvocation) {
        if (functionInvocation.isBindAttempted()) {
            return;
        }
        Object elem = functionInvocation.getTarget().resolveElement();
        if (elem instanceof Function) {
            Function func = (Function)elem;
            functionInvocation.setMember((Member)func);
            functionInvocation.setType(func.getType());
            this.dependencyRequestor.recordType(func.getType());
            return;
        }
        if (elem instanceof Constructor) {
            Constructor cons = (Constructor)elem;
            functionInvocation.setMember((Member)cons);
            functionInvocation.setType(cons.getType());
            this.dependencyRequestor.recordType(cons.getType());
            return;
        }
        if (functionInvocation.getTarget().resolveType() instanceof Delegate) {
            Delegate del = (Delegate)functionInvocation.getTarget().resolveType();
            functionInvocation.setElement(del);
            functionInvocation.setType(del.getReturnType());
            this.dependencyRequestor.recordType(del.getReturnType());
            return;
        }
        if (functionInvocation.getTarget() instanceof ThisExpression || functionInvocation.getTarget() instanceof SuperExpression) {
            org.eclipse.edt.mof.egl.Type type = functionInvocation.getTarget().resolveType();
            if (type != null) {
                List<Constructor> constructors = this.getConstructors(type);
                Constructor cons = null;
                if (constructors != null) {
                    functionInvocation.getTarget().setAttributeOnName(Name.OVERLOADED_FUNCTION_SET, constructors);
                    cons = IRUtils.resolveConstructorReferenceFromArgTypes((EGLClass)((EGLClass)type.getClassifier()), this.getArgumentTypes(functionInvocation.getArguments()), (boolean)false);
                }
                if (cons == null || BindingUtil.isPrivate(cons) && functionInvocation.getTarget() instanceof SuperExpression) {
                    if (cons != null || constructors != null && constructors.size() > 0 || functionInvocation.getArguments().size() > 0) {
                        this.problemRequestor.acceptProblem((Node)functionInvocation, 7830, new String[]{BindingUtil.getName((Element)type)});
                        functionInvocation.setBindAttempted(true);
                    }
                } else {
                    functionInvocation.setMember((Member)cons);
                    functionInvocation.setType(cons.getType());
                }
            }
            return;
        }
        if (elem instanceof List) {
            Function function2;
            functionInvocation.getTarget().setAttributeOnName(Name.OVERLOADED_FUNCTION_SET, elem);
            List functions = (List)elem;
            ArrayList<Function> functionsWithSameNumberArgs = new ArrayList<Function>();
            for (Function function2 : functions) {
                if (function2.getParameters().size() != functionInvocation.getArguments().size()) continue;
                functionsWithSameNumberArgs.add(function2);
            }
            functions = TypeUtils.getBestFitFunctionMember(functionsWithSameNumberArgs, (NamedElement[])this.getArgumentTypes(functionInvocation.getArguments()).toArray(new NamedElement[0]));
            if (functions.size() == 0) {
                this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 3469, new String[]{functionInvocation.getTarget().getCanonicalString()});
                functionInvocation.setBindAttempted(true);
                functionInvocation.getTarget().setMember(null);
                return;
            }
            if (functions.size() > 1) {
                this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 3468, new String[]{functionInvocation.getTarget().getCanonicalString()});
                functionInvocation.setBindAttempted(true);
                functionInvocation.getTarget().setMember(null);
                return;
            }
            function2 = (Function)functions.get(0);
            functionInvocation.getTarget().setMember((Member)function2);
            functionInvocation.setType(function2.getType());
            this.dependencyRequestor.recordType(function2.getType());
        }
    }

    @Override
    public void endVisit(MoveStatement moveStatement) {
    }

    @Override
    public void endVisit(CloseStatement closeStatement) {
    }

    @Override
    public void endVisit(SetValuesExpression setValuesExpression) {
    }

    @Override
    public void endVisit(ClassDataDeclaration classDataDeclaration) {
    }

    @Override
    public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
    }

    @Override
    public void endVisit(FunctionParameter functionParameter) {
    }

    public void endVisit(ProgramParameter programParameter) {
    }

    @Override
    public void endVisit(StructureItem structureItem) {
    }

    @Override
    public void endVisit(ReturnsDeclaration returnDecl) {
    }

    @Override
    public void endVisit(CallStatement callStatement) {
    }

    protected static class SetValuesExpressionCompletor
    extends DefaultBinder {
        TypeScope leftHandScope;

        public SetValuesExpressionCompletor(Scope currentScope, Part currentBinding, TypeScope leftHandScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
            this.leftHandScope = leftHandScope;
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            return true;
        }

        @Override
        public boolean visit(Assignment assignment) {
            Scope saved = this.currentScope;
            this.currentScope = this.leftHandScope;
            assignment.getLeftHandSide().accept(this);
            this.currentScope = saved;
            assignment.getRightHandSide().accept(this);
            return false;
        }

        @Override
        public boolean visit(SetValuesExpression setValuesExpression) {
            Scope saved = this.currentScope;
            this.currentScope = this.leftHandScope;
            setValuesExpression.getExpression().accept(this);
            this.currentScope = saved;
            org.eclipse.edt.mof.egl.Type type = setValuesExpression.getExpression().resolveType();
            if (type != null) {
                TypeScope newScope = new TypeScope(NullScope.INSTANCE, type);
                setValuesExpression.getSettingsBlock().accept(new SetValuesExpressionCompletor(this.currentScope, this.currentBinding, newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            } else {
                SetValuesExpressionCompletor.setBindAttemptedForNames(setValuesExpression.getSettingsBlock());
            }
            return false;
        }

        @Override
        public boolean visit(SuperExpression superExpression) {
            superExpression.setType(this.leftHandScope.getType());
            return false;
        }

        @Override
        public boolean visit(ThisExpression thisExpression) {
            thisExpression.setType(this.leftHandScope.getType());
            return false;
        }
    }
}

