/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.core.ast.Node;

public class ResolutionException
extends Exception {
    private static final long serialVersionUID = 3690471424653799990L;
    private int startOffset;
    private int endOffset;
    private int problemKind;
    private String[] inserts;

    public ResolutionException(int startOffset, int endOffset, int problemKind, String[] inserts) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.problemKind = problemKind;
        this.inserts = inserts;
    }

    public ResolutionException(int startOffset, int endOffset, int problemKind) {
        this(startOffset, endOffset, problemKind, new String[0]);
    }

    public ResolutionException(Node astNode, int problemKind, String[] inserts) {
        this(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), problemKind, inserts);
    }

    public ResolutionException(Node astNode, int problemKind) {
        this(astNode, problemKind, new String[0]);
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getProblemKind() {
        return this.problemKind;
    }

    public String[] getInserts() {
        return this.inserts;
    }
}

