/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup.System;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;

public class SystemLibraryManager {
    private Map<String, Library> libraries = new HashMap<String, Library>();
    private Map<String, List<Member>> libraryData = new HashMap<String, List<Member>>();

    public SystemLibraryManager(SystemLibraryManager parentLib) {
        if (parentLib != null) {
            this.libraries.putAll(parentLib.libraries);
            for (String key : this.libraryData.keySet()) {
                this.putLibraryData(key, this.libraryData.get(key));
            }
        }
    }

    public List<Member> findMember(String simpleName) {
        return this.getLibraryData().get(simpleName);
    }

    public Map<String, Library> getLibraries() {
        return this.libraries;
    }

    private Map<String, List<Member>> getLibraryData() {
        return this.libraryData;
    }

    public void addSystemLibrary(Library library) {
        this.libraries.put(library.getName(), library);
        this.addLibraryData(library);
    }

    private void addLibraryData(Library library) {
        for (Member mbr : library.getMembers()) {
            this.putLibraryData(mbr.getName(), mbr);
        }
    }

    private void putLibraryData(String name, Member mbr) {
        List<Member> list = this.getLibraryData().get(name);
        if (list == null) {
            list = new ArrayList<Member>();
            this.getLibraryData().put(name, list);
        }
        list.add(mbr);
    }

    private void putLibraryData(String name, List<Member> mbrs) {
        List<Member> list = this.getLibraryData().get(name);
        if (list == null) {
            list = new ArrayList<Member>();
            this.getLibraryData().put(name, list);
        }
        list.addAll(mbrs);
    }
}

