/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BytesLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.TernaryExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionArgumentValidator;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ExpressionValidator
extends AbstractASTVisitor {
    IPartBinding declaringPart;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;

    public ExpressionValidator(IPartBinding declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.declaringPart = declaringPart;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression) {
        HashMap<Expression, org.eclipse.edt.mof.egl.Type> lhsMap = new HashMap<Expression, org.eclipse.edt.mof.egl.Type>();
        HashMap<Expression, org.eclipse.edt.mof.egl.Type> rhsMap = new HashMap<Expression, org.eclipse.edt.mof.egl.Type>();
        TypeValidator.collectExprsForTypeCompatibility(binaryExpression.getFirstExpression(), lhsMap);
        TypeValidator.collectExprsForTypeCompatibility(binaryExpression.getSecondExpression(), rhsMap);
        for (Map.Entry lhsEntry : lhsMap.entrySet()) {
            NamedElement lhsElement = DefaultBinder.getOperandType((Expression)lhsEntry.getKey());
            if (lhsElement == null) continue;
            for (Map.Entry rhsEntry : rhsMap.entrySet()) {
                NamedElement rhsElement = DefaultBinder.getOperandType((Expression)rhsEntry.getKey());
                if (rhsElement == null) continue;
                Operation op = IRUtils.getBinaryOperation((NamedElement)lhsElement, (NamedElement)rhsElement, (String)binaryExpression.getOperator().toString());
                if (op != null) {
                    org.eclipse.edt.mof.egl.Type t;
                    Expression errorNode = null;
                    org.eclipse.edt.mof.egl.Type resolvingType = (org.eclipse.edt.mof.egl.Type)lhsEntry.getValue();
                    if (resolvingType == null || resolvingType.getClassifier() == null || !resolvingType.getClassifier().equals((org.eclipse.edt.mof.egl.Type)op.getType().getClassifier()).booleanValue()) {
                        resolvingType = (org.eclipse.edt.mof.egl.Type)rhsEntry.getValue();
                    }
                    if (BindingUtil.isUnresolvedGenericType(((FunctionParameter)op.getParameters().get(0)).getType()) && !BindingUtil.isMoveCompatible(t = BindingUtil.resolveGenericType(((FunctionParameter)op.getParameters().get(0)).getType(), resolvingType), (Member)op.getParameters().get(0), (org.eclipse.edt.mof.egl.Type)lhsEntry.getValue(), (Expression)lhsEntry.getKey())) {
                        errorNode = (Expression)lhsEntry.getKey();
                    }
                    if (errorNode == null && BindingUtil.isUnresolvedGenericType(((FunctionParameter)op.getParameters().get(1)).getType()) && !BindingUtil.isMoveCompatible(t = BindingUtil.resolveGenericType(((FunctionParameter)op.getParameters().get(1)).getType(), resolvingType), (Member)op.getParameters().get(1), (org.eclipse.edt.mof.egl.Type)rhsEntry.getValue(), (Expression)rhsEntry.getKey())) {
                        errorNode = (Expression)rhsEntry.getKey();
                    }
                    if (errorNode == null) continue;
                    this.problemRequestor.acceptProblem((Node)errorNode, 6653, new String[]{BindingUtil.getShortTypeString((Expression)lhsEntry.getKey(), (org.eclipse.edt.mof.egl.Type)lhsEntry.getValue()), BindingUtil.getShortTypeString((Expression)rhsEntry.getKey(), (org.eclipse.edt.mof.egl.Type)rhsEntry.getValue()), String.valueOf(((Expression)lhsEntry.getKey()).getCanonicalString()) + " " + binaryExpression.getOperator().toString() + " " + ((Expression)rhsEntry.getKey()).getCanonicalString()});
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)lhsEntry.getKey(), 5214, new String[]{((Expression)lhsEntry.getKey()).getCanonicalString(), ((Expression)rhsEntry.getKey()).getCanonicalString(), binaryExpression.getOperator().toString(), String.valueOf(((Expression)lhsEntry.getKey()).getCanonicalString()) + " " + binaryExpression.getOperator().toString() + " " + ((Expression)rhsEntry.getKey()).getCanonicalString()});
            }
        }
    }

    @Override
    public void endVisit(UnaryExpression unaryExpression) {
        Operation op;
        Expression operand = unaryExpression.getExpression();
        org.eclipse.edt.mof.egl.Type operandType = operand.resolveType();
        if (operandType != null && (op = IRUtils.getUnaryOperation((Classifier)operandType.getClassifier(), (String)unaryExpression.getOperator().toString())) == null) {
            this.problemRequestor.acceptProblem((Node)operand, 5216, new String[]{operand.getCanonicalString(), unaryExpression.getOperator().toString()});
        }
    }

    @Override
    public void endVisit(NewExpression newExpression) {
        Type type = newExpression.getType();
        if (type.resolveType() == null) {
            return;
        }
        TypeValidator.validate(type, this.declaringPart, this.problemRequestor, this.compilerOptions);
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            if (arrayType.hasInitialSize() && !BindingUtil.isZeroLiteral(arrayType.getInitialSize())) {
                ArrayType innerArrayType = arrayType;
                while (innerArrayType.getElementType().isArrayType()) {
                    innerArrayType = (ArrayType)innerArrayType.getElementType();
                }
                TypeValidator.validateInstantiatable(arrayType.getBaseType(), this.declaringPart, innerArrayType.isNullable(), this.problemRequestor);
            }
            boolean[] hasInitialSize = new boolean[1];
            newExpression.getType().accept(new AbstractASTVisitor(){

                @Override
                public boolean visit(ArrayType arrayType) {
                    if (arrayType.hasInitialSize()) {
                        HashMap<Expression, org.eclipse.edt.mof.egl.Type> exprMap = new HashMap<Expression, org.eclipse.edt.mof.egl.Type>();
                        TypeValidator.collectExprsForTypeCompatibility(arrayType.getInitialSize(), exprMap);
                        for (Map.Entry entry : exprMap.entrySet()) {
                            org.eclipse.edt.mof.egl.Type tBinding = (org.eclipse.edt.mof.egl.Type)entry.getValue();
                            if (tBinding == null || IRUtils.isMoveCompatible((org.eclipse.edt.mof.egl.Type)TypeUtils.Type_INT, (org.eclipse.edt.mof.egl.Type)tBinding, (Member)((Expression)entry.getKey()).resolveMember())) continue;
                            ExpressionValidator.this.problemRequestor.acceptProblem((Node)arrayType.getInitialSize(), 3263, new String[]{arrayType.getInitialSize().getCanonicalString()});
                        }
                    }
                    return true;
                }
            });
            if (hasInitialSize[0] && newExpression.hasSettingsBlock()) {
                final Node[] errorNode = new Node[1];
                newExpression.getSettingsBlock().accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visit(Assignment assignment) {
                        return false;
                    }

                    @Override
                    public boolean visit(AnnotationExpression annotationExpression) {
                        return false;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        return false;
                    }

                    @Override
                    public boolean visitExpression(Expression expression) {
                        if (errorNode[0] != null) {
                            return false;
                        }
                        errorNode[0] = expression;
                        return false;
                    }
                });
                if (errorNode[0] != null) {
                    this.problemRequestor.acceptProblem(errorNode[0], 3439, 2, new String[0]);
                }
            }
        } else if (type.isNameType() && !((NameType)type).hasArguments()) {
            TypeValidator.validateInstantiatable(type, this.declaringPart, false, this.problemRequestor);
        }
        if (newExpression.hasSettingsBlock()) {
            this.validateSettings(newExpression.getSettingsBlock(), newExpression);
        }
    }

    private void validateSettings(SettingsBlock settings, final Expression expr) {
        final org.eclipse.edt.mof.egl.Type[] arrayElementType = new org.eclipse.edt.mof.egl.Type[1];
        if (expr.resolveType() instanceof org.eclipse.edt.mof.egl.ArrayType) {
            arrayElementType[0] = ((org.eclipse.edt.mof.egl.ArrayType)expr.resolveType()).getElementType();
        }
        settings.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                ExpressionValidator.this.validateAssignment(assignment);
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                if (arrayElementType[0] != null) {
                    org.eclipse.edt.mof.egl.Type exprType = expression.resolveType();
                    if (!(BindingUtil.isMoveCompatible(arrayElementType[0], null, exprType, expression) || TypeUtils.Type_NULLTYPE.equals(exprType).booleanValue() && ((org.eclipse.edt.mof.egl.ArrayType)expr.resolveType()).elementsNullable())) {
                        ExpressionValidator.this.problemRequestor.acceptProblem((Node)expression, 6653, new String[]{BindingUtil.getShortTypeString(arrayElementType[0]), exprType != null ? BindingUtil.getShortTypeString(exprType) : expression.getCanonicalString(), String.valueOf(expr.getCanonicalString()) + ".appendElement(" + expression.getCanonicalString() + ")"});
                    }
                } else {
                    ExpressionValidator.this.problemRequestor.acceptProblem((Node)expression, 3253, new String[]{expression.getCanonicalString()});
                }
                return false;
            }
        });
    }

    @Override
    public void endVisit(FunctionInvocation functionInvocation) {
        Expression target = functionInvocation.getTarget();
        Object element = null;
        org.eclipse.edt.mof.egl.Type returnType = null;
        if (target.resolveElement() instanceof FunctionMember) {
            element = target.resolveElement();
            returnType = ((FunctionMember)element).getType();
        } else if (target.resolveType() instanceof Delegate) {
            element = target.resolveType();
            returnType = ((Delegate)element).getReturnType();
        }
        if (element == null && (target instanceof ThisExpression || target instanceof SuperExpression) && (element = functionInvocation.resolveElement()) instanceof FunctionMember) {
            returnType = ((FunctionMember)element).getReturnType();
        }
        if (element instanceof FunctionMember || element instanceof Delegate) {
            if (returnType == null && !(functionInvocation.getParent() instanceof FunctionInvocationStatement)) {
                this.problemRequestor.acceptProblem((Node)functionInvocation, 6654, new String[]{target.getCanonicalString()});
            }
            if (element instanceof Delegate) {
                functionInvocation.accept(new FunctionArgumentValidator((Delegate)element, this.problemRequestor, this.compilerOptions));
            } else if (element instanceof FunctionMember) {
                functionInvocation.accept(new FunctionArgumentValidator((FunctionMember)element, this.problemRequestor, this.compilerOptions));
            }
        } else if (element != null) {
            this.problemRequestor.acceptProblem(target, 6751);
        }
        if (target instanceof FieldAccess && ((FieldAccess)target).getPrimary() instanceof SuperExpression && element instanceof FunctionMember && ((FunctionMember)element).isAbstract().booleanValue()) {
            this.problemRequestor.acceptProblem((Node)target, 3015, new String[]{((FunctionMember)element).getCaseSensitiveName(), ((NamedElement)((FunctionMember)element).getContainer()).getCaseSensitiveName()});
        }
    }

    @Override
    public void endVisit(SetValuesExpression setValuesExpression) {
        if (!(setValuesExpression.getExpression() instanceof AnnotationExpression)) {
            this.validateSettings(setValuesExpression.getSettingsBlock(), setValuesExpression.getExpression());
        }
        if (setValuesExpression.getExpression().resolveType() instanceof Delegate || setValuesExpression.getExpression().resolveMember() instanceof FunctionMember) {
            this.problemRequestor.acceptProblem((Node)setValuesExpression.getSettingsBlock(), 3249, new String[0]);
        }
    }

    @Override
    public void endVisit(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.hasSettingsBlock()) {
            this.validateSettings(classDataDeclaration.getSettingsBlockOpt(), classDataDeclaration.getNames().get(0));
        }
    }

    @Override
    public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
        if (functionDataDeclaration.hasSettingsBlock()) {
            this.validateSettings(functionDataDeclaration.getSettingsBlockOpt(), functionDataDeclaration.getNames().get(0));
        }
    }

    private void validateAssignment(Assignment assignment) {
        Expression leftHandSide = assignment.getLeftHandSide();
        Expression rightHandSide = assignment.getRightHandSide();
        org.eclipse.edt.mof.egl.Type lhsType = leftHandSide.resolveType();
        if (!(lhsType instanceof AnnotationType)) {
            new AssignmentStatementValidator(this.problemRequestor, this.compilerOptions, this.declaringPart).validateAssignment(assignment.getOperator(), leftHandSide, rightHandSide, lhsType, rightHandSide.resolveType(), leftHandSide.resolveMember(), rightHandSide.resolveMember());
        }
    }

    @Override
    public void endVisit(IsAExpression isAExpression) {
        this.checkTypeForIsaOrAs(isAExpression.getType());
    }

    @Override
    public void endVisit(AsExpression asExpression) {
        if (asExpression.hasType()) {
            this.checkTypeForIsaOrAs(asExpression.getType());
            org.eclipse.edt.mof.egl.Type toType = asExpression.getType().resolveType();
            if (toType != null) {
                HashMap<Expression, org.eclipse.edt.mof.egl.Type> exprMap = new HashMap<Expression, org.eclipse.edt.mof.egl.Type>();
                TypeValidator.collectExprsForTypeCompatibility(asExpression.getExpression(), exprMap);
                for (Map.Entry entry : exprMap.entrySet()) {
                    if (entry.getValue() == null || BindingUtil.isMoveCompatible(toType, null, (org.eclipse.edt.mof.egl.Type)entry.getValue(), (Expression)entry.getKey())) continue;
                    this.problemRequestor.acceptProblem((Node)entry.getKey(), 6653, new String[]{BindingUtil.getShortTypeString((Expression)entry.getKey(), (org.eclipse.edt.mof.egl.Type)entry.getValue()), BindingUtil.getShortTypeString(toType, true), String.valueOf(((Expression)entry.getKey()).getCanonicalString()) + " as " + asExpression.getType().getCanonicalName()});
                }
            }
        }
    }

    private void checkTypeForIsaOrAs(Type type) {
        TypeValidator.validate(type, this.declaringPart, this.problemRequestor, this.compilerOptions);
        Type tempType = type;
        while (tempType.isArrayType()) {
            if (((ArrayType)tempType).hasInitialSize()) {
                this.problemRequestor.acceptProblem(((ArrayType)tempType).getInitialSize(), 3264);
            }
            tempType = ((ArrayType)tempType).getElementType();
        }
    }

    @Override
    public void endVisit(IntegerLiteral integerLiteral) {
        String strVal = String.valueOf(this.getSign(integerLiteral.getParent(), false)) + integerLiteral.getValue();
        if (integerLiteral.getLiteralKind() == 14) {
            try {
                Long.parseLong(strVal, 10);
            }
            catch (NumberFormatException numberFormatException) {
                this.problemRequestor.acceptProblem((Node)integerLiteral, 3278, new String[]{strVal});
            }
        } else if (integerLiteral.getLiteralKind() == 13) {
            try {
                Short.parseShort(strVal, 10);
            }
            catch (NumberFormatException numberFormatException) {
                this.problemRequestor.acceptProblem((Node)integerLiteral, 3279, new String[]{strVal});
            }
        } else {
            try {
                Integer.parseInt(strVal, 10);
            }
            catch (NumberFormatException numberFormatException) {
                this.problemRequestor.acceptProblem((Node)integerLiteral, 3250, new String[]{strVal});
            }
        }
    }

    @Override
    public void endVisit(DecimalLiteral decimalLiteral) {
        String strVal = decimalLiteral.getValue();
        if (strVal.length() > (strVal.indexOf(46) == -1 ? 32 : 33)) {
            this.problemRequestor.acceptProblem((Node)decimalLiteral, 3251, new String[]{strVal});
        }
    }

    @Override
    public void endVisit(FloatLiteral floatLiteral) {
        try {
            if (floatLiteral.getLiteralKind() == 15) {
                String strVal = floatLiteral.getValue();
                if (Float.isInfinite(Float.parseFloat(strVal))) {
                    this.problemRequestor.acceptProblem((Node)floatLiteral, 3280, new String[]{strVal});
                }
            } else {
                String strVal = floatLiteral.getValue();
                if (Double.isInfinite(Double.parseDouble(strVal))) {
                    this.problemRequestor.acceptProblem((Node)floatLiteral, 3252, new String[]{strVal});
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    public void endVisit(BytesLiteral bytesLiteral) {
        if (bytesLiteral.getValue().length() % 2 != 0) {
            this.problemRequestor.acceptProblem((Node)bytesLiteral, 3277, new String[]{bytesLiteral.getCanonicalString()});
        }
    }

    @Override
    public void endVisit(IsNotExpression isNotExpression) {
        this.problemRequestor.acceptProblem((Node)isNotExpression, 5009, new String[0]);
    }

    private String getSign(Node node, boolean hasNegativeSign) {
        if (node instanceof ParenthesizedExpression) {
            return this.getSign(node.getParent(), hasNegativeSign);
        }
        if (node instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)node;
            if (unary.getOperator() == UnaryExpression.Operator.MINUS) {
                return this.getSign(unary.getParent(), !hasNegativeSign);
            }
            if (unary.getOperator() == UnaryExpression.Operator.PLUS) {
                return this.getSign(unary.getParent(), hasNegativeSign);
            }
        }
        if (hasNegativeSign) {
            return "-";
        }
        return "";
    }

    @Override
    public void endVisit(SubstringAccess substringAccess) {
        Operation op;
        org.eclipse.edt.mof.egl.Type type = substringAccess.getPrimary().resolveType();
        if (type != null && (op = IRUtils.getOperation((Classifier)type.getClassifier(), (String)"[:")) == null) {
            this.problemRequestor.acceptProblem((Node)substringAccess, 5215, new String[]{substringAccess.getPrimary().getCanonicalString()});
        }
        this.checkSubstringIndex(substringAccess.getExpr(), substringAccess);
        this.checkSubstringIndex(substringAccess.getExpr2(), substringAccess);
    }

    private void checkSubstringIndex(Expression index, SubstringAccess parentAccess) {
        org.eclipse.edt.mof.egl.Type tBinding = index.resolveType();
        if (tBinding != null) {
            boolean typeIsValid = false;
            if (TypeUtils.Type_ANY.equals(tBinding).booleanValue() || TypeUtils.isNumericType((org.eclipse.edt.mof.egl.Type)tBinding)) {
                typeIsValid = tBinding instanceof FixedPrecisionType ? ((FixedPrecisionType)tBinding).getDecimals() == 0 : true;
            }
            if (!typeIsValid) {
                this.problemRequestor.acceptProblem((Node)index, 3363, new String[]{index.getCanonicalString(), parentAccess.getCanonicalString()});
            }
        }
    }

    @Override
    public void endVisit(FieldAccess fieldAccess) {
        Object element;
        if (fieldAccess.getPrimary().resolveType() instanceof org.eclipse.edt.mof.egl.ArrayType && !(fieldAccess.resolveMember() instanceof FunctionMember)) {
            this.problemRequestor.acceptProblem((Node)fieldAccess.getPrimary(), 6585, new String[]{fieldAccess.getPrimary().getCanonicalString()});
        }
        final boolean[] dynamicAccessUsed = new boolean[1];
        fieldAccess.getPrimary().accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                org.eclipse.edt.mof.egl.Type indexType;
                if (arrayAccess.getIndices().size() == 1 && (indexType = arrayAccess.getIndices().get(0).resolveType()) != null && TypeUtils.isTextType((org.eclipse.edt.mof.egl.Type)indexType)) {
                    dynamicAccessUsed[0] = true;
                }
                return true;
            }
        });
        if (dynamicAccessUsed[0]) {
            this.problemRequestor.acceptProblem(fieldAccess, 6584);
        }
        if ((element = fieldAccess.resolveElement()) instanceof Member && !((Member)element).isStatic().booleanValue() && fieldAccess.getPrimary().resolveElement() instanceof org.eclipse.edt.mof.egl.Type) {
            if (element instanceof FunctionMember) {
                if (!(fieldAccess.getParent() instanceof CallStatement) || fieldAccess != ((CallStatement)fieldAccess.getParent()).getInvocationTarget()) {
                    this.problemRequestor.acceptProblem((Node)fieldAccess, 3406, new String[]{String.valueOf(fieldAccess.getCaseSensitiveID()) + "(" + FunctionContainerValidator.getTypeNamesList(((FunctionMember)element).getParameters()) + ")"});
                }
            } else {
                this.problemRequestor.acceptProblem((Node)fieldAccess, 3405, new String[]{fieldAccess.getCaseSensitiveID()});
            }
        }
    }

    @Override
    public void endVisit(QualifiedName qualifiedName) {
        Object element;
        if (qualifiedName.getQualifier().resolveType() instanceof org.eclipse.edt.mof.egl.ArrayType && !(qualifiedName.resolveMember() instanceof Function)) {
            this.problemRequestor.acceptProblem((Node)qualifiedName.getQualifier(), 6585, new String[]{qualifiedName.getQualifier().getCanonicalName()});
        }
        if ((element = qualifiedName.resolveElement()) instanceof Member && !((Member)element).isStatic().booleanValue() && qualifiedName.getQualifier().resolveElement() instanceof org.eclipse.edt.mof.egl.Type) {
            if (element instanceof FunctionMember) {
                if (!(qualifiedName.getParent() instanceof CallStatement) || qualifiedName != ((CallStatement)qualifiedName.getParent()).getInvocationTarget()) {
                    this.problemRequestor.acceptProblem((Node)qualifiedName, 3406, new String[]{String.valueOf(qualifiedName.getCaseSensitiveIdentifier()) + "(" + FunctionContainerValidator.getTypeNamesList(((FunctionMember)element).getParameters()) + ")"});
                }
            } else {
                this.problemRequestor.acceptProblem((Node)qualifiedName, 3405, new String[]{qualifiedName.getCaseSensitiveIdentifier()});
            }
        }
    }

    @Override
    public void endVisit(TernaryExpression ternaryExpression) {
        org.eclipse.edt.mof.egl.Type conditionType = ternaryExpression.getFirstExpr().resolveType();
        if (conditionType != null && !conditionType.equals(TypeUtils.Type_BOOLEAN).booleanValue()) {
            this.problemRequestor.acceptProblem((Node)ternaryExpression.getFirstExpr(), 6653, new String[]{BindingUtil.getShortTypeString(conditionType), "boolean", ternaryExpression.getFirstExpr().getCanonicalString()});
        }
    }

    @Override
    public void endVisit(ArrayAccess arrayAccess) {
        if (arrayAccess.getIndices().size() > 1) {
            this.problemRequestor.acceptProblem((Node)arrayAccess, 3472, new String[]{arrayAccess.getCanonicalString()});
        } else {
            Expression index = arrayAccess.getIndices().get(0);
            org.eclipse.edt.mof.egl.Type indexType = index.resolveType();
            org.eclipse.edt.mof.egl.Type arrayType = arrayAccess.getArray().resolveType();
            if (indexType != null) {
                if (TypeUtils.isTextType((org.eclipse.edt.mof.egl.Type)indexType)) {
                    if (arrayType != null && !BindingUtil.isDynamicallyAccessible(arrayType)) {
                        this.problemRequestor.acceptProblem((Node)arrayAccess.getArray(), 6588, new String[]{arrayAccess.getArray().getCanonicalString()});
                    }
                } else {
                    boolean indexTypeIsValid = false;
                    if (TypeUtils.Type_ANY.equals(indexType).booleanValue() || TypeUtils.isNumericType((org.eclipse.edt.mof.egl.Type)indexType)) {
                        indexTypeIsValid = indexType instanceof FixedPrecisionType ? ((FixedPrecisionType)indexType).getDecimals() == 0 : true;
                    }
                    if (!indexTypeIsValid) {
                        this.problemRequestor.acceptProblem((Node)index, 6583, new String[]{index.getCanonicalString(), arrayAccess.getCanonicalString()});
                    }
                    if (arrayType != null && !TypeUtils.Type_ANY.equals(arrayType).booleanValue() && !(arrayType instanceof org.eclipse.edt.mof.egl.ArrayType)) {
                        this.problemRequestor.acceptProblem((Node)arrayAccess.getArray(), 6586, new String[]{arrayAccess.getArray().getCanonicalString()});
                    }
                }
            }
        }
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        return !(setValuesExpression.getExpression().resolveType() instanceof AnnotationType);
    }
}

