/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.binding.FieldContentValidationRule;
import org.eclipse.edt.compiler.binding.IValidationProxy;
import org.eclipse.edt.compiler.binding.InvocationValidationRule;
import org.eclipse.edt.compiler.binding.PartContentValidationRule;
import org.eclipse.edt.compiler.binding.ValueValidationRule;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.utils.NameUtile;

public class AnnotationValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IProblemRequestor storedProblemRequestor;

    public AnnotationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    private IProblemRequestor restoreProblemRequestor() {
        IProblemRequestor result = this.storedProblemRequestor;
        this.storedProblemRequestor = null;
        return result;
    }

    private IProblemRequestor specializeProblemRequestor(IProblemRequestor problemRequestor, Node target, Annotation annotation) {
        return this.specializeProblemRequestor(problemRequestor, target, (AnnotationType)annotation.getEClass());
    }

    private IProblemRequestor specializeProblemRequestor(IProblemRequestor problemRequestor, Node target, AnnotationType annotationType) {
        this.storedProblemRequestor = problemRequestor;
        IProblemRequestor result = problemRequestor;
        return result;
    }

    public static IValidationProxy getValidationProxy(Annotation annot) {
        String proxy;
        EClass eclass;
        if (annot != null && (eclass = annot.getEClass()) instanceof AnnotationType && (proxy = ((AnnotationType)eclass).getValidationProxy()) != null && (proxy = proxy.trim()).length() > 0) {
            try {
                Class<?> c = AnnotationValidator.class.getClassLoader().loadClass(proxy);
                IValidationProxy valProxy = (IValidationProxy)c.getMethod("getInstance", null).invoke(null, null);
                valProxy.setType((AnnotationType)eclass);
                return valProxy;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void validateAnnotationTarget(Node target) {
        target.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
                IValidationProxy proxy = null;
                Stereotype subtype = null;
                org.eclipse.edt.mof.egl.Type type = record.getName().resolveType();
                if (type instanceof org.eclipse.edt.mof.egl.Part && (subtype = ((org.eclipse.edt.mof.egl.Part)type).getStereotype()) != null) {
                    proxy = AnnotationValidator.getValidationProxy((Annotation)subtype);
                }
                this.validateExpressions(record);
                if (proxy == null) {
                    return false;
                }
                AnnotationValidator.this.processPartSubTypeSubAnnotations(record.getName(), record, (Annotation)subtype, proxy.getAnnotationValidators());
                AnnotationValidator.this.processPartSubTypeFields(record, record.getContents(), proxy);
                AnnotationValidator.this.processPartSubType(record, proxy);
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(record);
                return false;
            }

            public boolean visitFunctionContainer(Part functionContainerPart, Name subType) {
                IValidationProxy proxy = null;
                Stereotype subtype = null;
                org.eclipse.edt.mof.egl.Type type = functionContainerPart.getName().resolveType();
                if (type instanceof org.eclipse.edt.mof.egl.Part && (subtype = ((org.eclipse.edt.mof.egl.Part)type).getStereotype()) != null) {
                    proxy = AnnotationValidator.getValidationProxy((Annotation)subtype);
                }
                this.validateExpressions(functionContainerPart);
                if (proxy == null) {
                    return false;
                }
                AnnotationValidator.this.processPartSubTypeSubAnnotations(functionContainerPart.getName(), functionContainerPart, (Annotation)subtype, proxy.getAnnotationValidators());
                AnnotationValidator.this.processPartSubTypeFields(functionContainerPart, functionContainerPart.getContents(), proxy);
                AnnotationValidator.this.processPartSubType(functionContainerPart, proxy);
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(functionContainerPart);
                return false;
            }

            @Override
            public boolean visit(Program program) {
                this.visitFunctionContainer(program, program.getSubType());
                return false;
            }

            @Override
            public boolean visit(Library library) {
                this.visitFunctionContainer(library, library.getSubType());
                return false;
            }

            @Override
            public boolean visit(Handler handler) {
                this.visitFunctionContainer(handler, handler.getSubType());
                return false;
            }

            @Override
            public boolean visit(Interface interfaceNode) {
                this.visitFunctionContainer(interfaceNode, interfaceNode.getSubType());
                return false;
            }

            @Override
            public boolean visit(Service serviceNode) {
                this.visitFunctionContainer(serviceNode, serviceNode.getSubType());
                return false;
            }

            @Override
            public boolean visit(NestedFunction function) {
                Member m = function.getName().resolveMember();
                if (m != null) {
                    AnnotationValidator.this.processAnnotations(function, (Element)m);
                }
                return false;
            }

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor constructor) {
                Constructor c = constructor.getBinding();
                if (c != null) {
                    AnnotationValidator.this.processAnnotations(constructor, (Element)c);
                }
                return false;
            }

            @Override
            public boolean visit(ExternalType externalType) {
                this.visitFunctionContainer(externalType, externalType.getSubType());
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                AnnotationValidator.this.processAnnotations(structureItem, (Element)structureItem.getName().resolveMember());
                if (structureItem.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(structureItem.getSettingsBlock());
                }
                if (structureItem.getName().resolveMember() != null && !structureItem.hasInitializer() && !structureItem.isNullable()) {
                    this.validateInvocation(structureItem, (Element)AnnotationValidator.this.getDefaultConstructor(structureItem.getType().resolveType()), BindingUtil.getDeclaringPart(structureItem.getName().resolveMember()));
                }
                return false;
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                Member field;
                AnnotationValidator.this.processAnnotations(classDataDeclaration, (Element)classDataDeclaration.getNames().get(0).resolveMember());
                if (classDataDeclaration.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(classDataDeclaration.getSettingsBlockOpt());
                }
                if ((field = classDataDeclaration.getNames().get(0).resolveMember()) != null && !classDataDeclaration.hasInitializer() && !classDataDeclaration.isNullable()) {
                    this.validateInvocation(classDataDeclaration, (Element)AnnotationValidator.this.getDefaultConstructor(classDataDeclaration.getType().resolveType()), BindingUtil.getDeclaringPart(field));
                }
                return false;
            }

            private void validateExpressions(Part part) {
                if (part.getName().resolveType() == null) {
                    return;
                }
                final org.eclipse.edt.mof.egl.Part partBinding = (org.eclipse.edt.mof.egl.Part)part.getName().resolveType();
                part.accept(new AbstractASTVisitor(){

                    @Override
                    public boolean visit(BinaryExpression binaryExpression) {
                        RValueValidator validator;
                        if (binaryExpression.getFirstExpression() != null) {
                            validator = new RValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, binaryExpression.getFirstExpression().resolveMember(), binaryExpression.getFirstExpression());
                            validator.validate();
                        }
                        if (binaryExpression.getSecondExpression() != null) {
                            validator = new RValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, binaryExpression.getSecondExpression().resolveMember(), binaryExpression.getSecondExpression());
                            validator.validate();
                        }
                        return true;
                    }

                    @Override
                    public boolean visit(UnaryExpression unaryExpression) {
                        RValueValidator validator = new RValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, unaryExpression.getExpression().resolveMember(), unaryExpression.getExpression());
                        validator.validate();
                        return true;
                    }

                    @Override
                    public boolean visit(ArrayAccess arrayAccess) {
                        for (Expression expr : arrayAccess.getIndices()) {
                            RValueValidator validator = new RValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, expr.resolveMember(), expr);
                            validator.validate();
                        }
                        return true;
                    }

                    @Override
                    public boolean visit(NewExpression newExpression) {
                        if (newExpression.resolveConstructor() != null) {
                            this.validateInvocation(newExpression, (Element)newExpression.resolveConstructor(), partBinding);
                        }
                        if (newExpression.getType().resolveType() != null && newExpression.getType().resolveType() instanceof org.eclipse.edt.mof.egl.ArrayType) {
                            ArrayType arrType = (ArrayType)newExpression.getType();
                            org.eclipse.edt.mof.egl.Type baseType = BindingUtil.getBaseType(newExpression.resolveType());
                            if (arrType.hasInitialSize() && !BindingUtil.isZeroLiteral(arrType.getInitialSize()) && baseType != null) {
                                this.validateInvocation(newExpression, (Element)AnnotationValidator.this.getDefaultConstructor(baseType), partBinding);
                            }
                        }
                        return true;
                    }

                    @Override
                    public boolean visit(FunctionInvocation functionInvocation) {
                        this.validateInvocation(functionInvocation, (Element)functionInvocation.getTarget().resolveMember(), partBinding);
                        return true;
                    }
                });
            }

            private void validateInvocation(Node node, Element element, org.eclipse.edt.mof.egl.Part declaringPart) {
                if (element != null) {
                    for (Annotation annot : element.getAnnotations()) {
                        IValidationProxy proxy = AnnotationValidator.getValidationProxy(annot);
                        if (proxy == null) continue;
                        for (InvocationValidationRule rule : proxy.getInvocationValidators()) {
                            rule.validate(node, element, declaringPart, AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                }
            }

            @Override
            public boolean visit(UseStatement useStatement) {
                org.eclipse.edt.mof.egl.Type type;
                List<Name> names = useStatement.getNames();
                if (names.size() > 0 && (type = names.get(0).resolveType()) != null) {
                    AnnotationValidator.this.processAnnotations(useStatement, (Element)type);
                }
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                Member field;
                AnnotationValidator.this.processAnnotations(functionDataDeclaration, (Element)functionDataDeclaration.getNames().get(0).resolveMember());
                if (functionDataDeclaration.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(functionDataDeclaration.getSettingsBlockOpt());
                }
                if ((field = functionDataDeclaration.getNames().get(0).resolveMember()) != null && !functionDataDeclaration.hasInitializer() && !functionDataDeclaration.isNullable()) {
                    this.validateInvocation(functionDataDeclaration, (Element)AnnotationValidator.this.getDefaultConstructor(functionDataDeclaration.getType().resolveType()), BindingUtil.getDeclaringPart(field));
                }
                return false;
            }
        });
    }

    private void processAnnotations(final Node target, final Element targetElement) {
        target.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (classDataDeclaration.hasSettingsBlock()) {
                    classDataDeclaration.getSettingsBlockOpt().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                if (functionDataDeclaration.hasSettingsBlock()) {
                    functionDataDeclaration.getSettingsBlockOpt().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                final 2 superVisitor = this;
                DefaultASTVisitor visitor = new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NestedFunction nestedFunction) {
                        return true;
                    }

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        settingsBlock.accept(superVisitor);
                        return false;
                    }
                };
                nestedFunction.accept(visitor);
                return false;
            }

            @Override
            public boolean visit(UseStatement useStatement) {
                if (useStatement.hasSettingsBlock()) {
                    useStatement.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasSettingsBlock()) {
                    structureItem.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                IValidationProxy proxy;
                Annotation annot = annotationExpression.resolveAnnotation();
                if (annot != null && (proxy = AnnotationValidator.getValidationProxy(annot)) != null) {
                    AnnotationValidator.this.processSubAnnotations(annotationExpression, target, targetElement, annot, proxy.getAnnotationValidators());
                }
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression annotationExpression = setValuesExpression.getExpression();
                Object annotationExpressionDBinding = annotationExpression.resolveElement();
                if (annotationExpressionDBinding instanceof Annotation) {
                    SettingsBlock settingsBlock = setValuesExpression.getSettingsBlock();
                    IValidationProxy proxy = AnnotationValidator.getValidationProxy((Annotation)annotationExpressionDBinding);
                    if (proxy != null) {
                        AnnotationValidator.this.processSubAnnotations(annotationExpression, target, targetElement, (Annotation)annotationExpressionDBinding, proxy.getAnnotationValidators());
                        AnnotationValidator.this.processComplexAnnotationFields(target, settingsBlock, proxy);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                Annotation aBinding = assignment.resolveBinding();
                if (aBinding != null) {
                    IValidationProxy validationProxy = AnnotationValidator.getValidationProxy(aBinding);
                    AnnotationValidator.this.processSubAnnotations(assignment, target, targetElement, aBinding, validationProxy.getAnnotationValidators());
                    AnnotationValidator.this.processComplexAnnotationFields(target, assignment, validationProxy);
                }
                return false;
            }

            @Override
            public boolean visitExpression(final Expression expression) {
                target.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ClassDataDeclaration classDataDeclaration) {
                        classDataDeclaration.getType().accept(this);
                        return false;
                    }

                    @Override
                    public boolean visit(StructureItem structureItem) {
                        structureItem.getType().accept(this);
                        return false;
                    }

                    @Override
                    public boolean visit(ArrayType arrayType) {
                        if (arrayType.hasInitialSize()) {
                            org.eclipse.edt.mof.egl.Type exprType;
                            org.eclipse.edt.mof.egl.Type targetTypeBinding = null;
                            if (targetElement instanceof org.eclipse.edt.mof.egl.Type) {
                                targetTypeBinding = (org.eclipse.edt.mof.egl.Type)targetElement;
                            }
                            if (targetTypeBinding instanceof org.eclipse.edt.mof.egl.ArrayType && (exprType = expression.resolveType()) != null && !BindingUtil.isMoveCompatible(((org.eclipse.edt.mof.egl.ArrayType)targetTypeBinding).getElementType(), null, exprType, null)) {
                                AnnotationValidator.this.problemRequestor.acceptProblem((Node)expression, 6653, new String[]{exprType.getTypeSignature(), ((org.eclipse.edt.mof.egl.ArrayType)targetTypeBinding).getElementType().getTypeSignature(), expression.getCanonicalString()});
                            }
                        }
                        return false;
                    }
                });
                return false;
            }
        });
    }

    private void processOverriddenAnnotationsAndSetValues(Node target) {
        target.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
                return true;
            }

            @Override
            public boolean visit(Program program) {
                return true;
            }

            @Override
            public boolean visit(Library library) {
                return true;
            }

            @Override
            public boolean visit(Handler handler) {
                return true;
            }

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Class eglClass) {
                return true;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression annotationExpression = setValuesExpression.getExpression();
                Member annotationExpressionDBinding = annotationExpression.resolveMember();
                if (annotationExpressionDBinding != null) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(setValuesExpression.getSettingsBlock());
                }
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                Annotation aBinding = assignment.resolveBinding();
                if (aBinding == null) {
                    org.eclipse.edt.mof.egl.Type lhType = assignment.getLeftHandSide().resolveType();
                    org.eclipse.edt.mof.egl.Type rhType = assignment.getRightHandSide().resolveType();
                    if (lhType != null && rhType != null && !(lhType instanceof AnnotationType)) {
                        new AssignmentStatementValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, null).validateAssignment(assignment.getOperator(), assignment.getLeftHandSide(), assignment.getRightHandSide(), assignment.getLeftHandSide().resolveType(), assignment.getRightHandSide().resolveType(), assignment.getLeftHandSide().resolveMember(), assignment.getRightHandSide().resolveMember());
                    }
                }
                return false;
            }
        });
    }

    private void processComplexAnnotationFields(final Node target, SettingsBlock settingsBlock, final IValidationProxy proxy) {
        List<ValueValidationRule> rules;
        String name;
        Object value;
        Annotation annot;
        List fields;
        Object element;
        final boolean[] processed = new boolean[1];
        settingsBlock.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                AnnotationValidator.this.processAnnotations(setValuesExpression, null);
                processed[0] = true;
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                AnnotationValidator.this.processAnnotations(annotationExpression, null);
                processed[0] = true;
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                AnnotationValidator.this.processComplexAnnotationFields(target, assignment, proxy);
                processed[0] = true;
                return true;
            }
        });
        if (!processed[0] && settingsBlock.getSettings().size() == 1 && settingsBlock.getParent() instanceof SetValuesExpression && (element = ((SetValuesExpression)settingsBlock.getParent()).getExpression().resolveElement()) instanceof Annotation && (fields = (annot = (Annotation)element).getEClass().getEFields()).size() == 1 && (value = annot.getValue(name = NameUtile.getAsName((String)((EField)fields.get(0)).getName()))) != null && (rules = proxy.getFieldValidators(name)) != null && rules.size() > 0) {
            for (ValueValidationRule nextRule : rules) {
                nextRule.validate(settingsBlock.getParent(), target, annot, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void processComplexAnnotationFields(Node target, Assignment assignment, IValidationProxy proxy) {
        List<ValueValidationRule> annotations;
        String name;
        Object value;
        Annotation aBinding = assignment.resolveBinding();
        if (aBinding != null && proxy != null && (value = aBinding.getValue(name = NameUtile.getAsName((String)assignment.getLeftHandSide().getCanonicalString()))) != null && (annotations = proxy.getFieldValidators(name)) != null) {
            for (ValueValidationRule nextRule : annotations) {
                nextRule.validate(assignment.getRightHandSide(), target, aBinding, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void processSubAnnotations(Node errorNode, Node target, Element targetElement, Annotation annotation, List<AnnotationValidationRule> rules) {
        if (rules != null && rules.size() > 0) {
            HashMap<String, Object> allAnnotationsAndFieldsMap = new HashMap<String, Object>();
            allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)annotation.getEClass().getName()), annotation);
            for (Annotation annot : annotation.getAnnotations()) {
                allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)annot.getEClass().getName()), annot);
            }
            for (EField efield : annotation.getEClass().getEFields()) {
                Object value = annotation.getValue(efield.getName());
                if (value == null) continue;
                allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)efield.getName()), value);
            }
            for (AnnotationValidationRule rule : rules) {
                this.problemRequestor = this.specializeProblemRequestor(this.problemRequestor, target, annotation);
                rule.validate(errorNode, target, targetElement, allAnnotationsAndFieldsMap, this.problemRequestor, this.compilerOptions);
                this.problemRequestor = this.restoreProblemRequestor();
            }
        }
    }

    private void processPartSubTypeSubAnnotations(Node errorNode, Node target, Annotation subTypeBinding, List<AnnotationValidationRule> rules) {
        if (rules != null && rules.size() > 0) {
            HashMap<String, Object> allAnnotationsAndFieldsMap = new HashMap<String, Object>();
            allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)subTypeBinding.getEClass().getName()), subTypeBinding);
            for (Annotation annot : subTypeBinding.getAnnotations()) {
                allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)annot.getEClass().getName()), annot);
            }
            for (EField efield : subTypeBinding.getEClass().getEFields()) {
                Object value = subTypeBinding.getValue(efield.getName());
                if (value == null) continue;
                allAnnotationsAndFieldsMap.put(NameUtile.getAsName((String)efield.getName()), value);
            }
            for (AnnotationValidationRule rule : rules) {
                rule.validate(errorNode, target, null, allAnnotationsAndFieldsMap, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void processPartSubTypeFields(final Node target, List<Node> partContents, final IValidationProxy proxy) {
        for (Node node : partContents) {
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SettingsBlock settingsBlock) {
                    AnnotationValidator.this.processComplexAnnotationFields(target, settingsBlock, proxy);
                    return false;
                }
            });
        }
    }

    private void processPartSubType(Part part, IValidationProxy proxy) {
        this.processPartSubType(part.getName(), part, part.getContents(), proxy);
    }

    private void processPartSubType(Name partName, Node partNode, List<Node> partContents, final IValidationProxy proxy) {
        final HashMap<String, Map<Annotation, Object[]>> allPartAnnotations = new HashMap<String, Map<Annotation, Object[]>>();
        for (Node node : partContents) {
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(StructureItem structureItem) {
                    Member structureItemBinding = structureItem.getName().resolveMember();
                    if (structureItemBinding != null) {
                        List annotations = structureItemBinding.getAnnotations();
                        Name nodeForErrors = structureItem.getName();
                        String canonicalItemName = structureItem.getName().getCanonicalName();
                        this.processContentAnnotations(structureItem, nodeForErrors, structureItemBinding, canonicalItemName, annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(ClassDataDeclaration classDataDeclaration) {
                    List<Name> names = classDataDeclaration.getNames();
                    for (Name name : names) {
                        Member classBinding = name.resolveMember();
                        if (classBinding == null) continue;
                        List annotations = classBinding.getAnnotations();
                        this.processContentAnnotations(classDataDeclaration, name, classBinding, name.getCanonicalName(), annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor constructor) {
                    for (FunctionParameter param : constructor.getParameters()) {
                        Member paramBinding = param.getName().resolveMember();
                        if (paramBinding == null) continue;
                        for (FieldContentValidationRule rule : proxy.getPartSubTypeValidators()) {
                            rule.validateFunctionParameter(param, paramBinding, AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visit(NestedFunction nestedFunction) {
                    Member nestedFunctionBinding;
                    Type returnType;
                    org.eclipse.edt.mof.egl.Type returnTypeBinding;
                    for (FunctionParameter param : nestedFunction.getFunctionParameters()) {
                        Member paramBinding = param.getName().resolveMember();
                        if (paramBinding == null) continue;
                        for (FieldContentValidationRule rule : proxy.getPartSubTypeValidators()) {
                            rule.validateFunctionParameter(param, paramBinding, AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    if (nestedFunction.hasReturnType() && (returnTypeBinding = (returnType = nestedFunction.getReturnType()).resolveType()) != null) {
                        for (FieldContentValidationRule rule : proxy.getPartSubTypeValidators()) {
                            rule.validateFunctionReturnType(returnType, returnTypeBinding, ((Part)nestedFunction.getParent()).getName().resolveMember(), AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    if ((nestedFunctionBinding = nestedFunction.getName().resolveMember()) != null) {
                        this.processContentAnnotations(nestedFunction, nestedFunction.getName(), nestedFunctionBinding, nestedFunction.getName().getCanonicalName(), nestedFunctionBinding.getAnnotations());
                    }
                    return false;
                }

                private void processContentAnnotations(Node field, Node nodeForErrors, Member containerBinding, String canonicalContainerName, List<Annotation> annotations) {
                    Map allAnnotationsMap = AnnotationValidator.this.getAllAnnotationsMap(annotations, allPartAnnotations, nodeForErrors, containerBinding);
                    for (FieldContentValidationRule rule : proxy.getPartSubTypeValidators()) {
                        AnnotationValidator.this.runFieldContentRuleOnBindingAndChildren(rule, containerBinding, containerBinding, nodeForErrors, field, canonicalContainerName, allAnnotationsMap, allPartAnnotations, AnnotationValidator.this.problemRequestor);
                    }
                }
            });
        }
        if (proxy != null) {
            for (PartContentValidationRule rule : proxy.getPartTypeValidators()) {
                rule.validate(partName, partNode, allPartAnnotations, this.problemRequestor);
            }
        }
    }

    private Map<String, Annotation> getAllAnnotationsMap(List<Annotation> annotations, Map<String, Map<Annotation, Object[]>> allPartAnnotations, Node field, Member targetDBinding) {
        HashMap<String, Annotation> allAnnotationsMap = new HashMap<String, Annotation>();
        for (Annotation annotationBinding : annotations) {
            allAnnotationsMap.put(NameUtile.getAsName((String)annotationBinding.getEClass().getName()), annotationBinding);
            LinkedHashMap<Annotation, Object[]> allAnnotationsForName = (LinkedHashMap<Annotation, Object[]>)allPartAnnotations.get(NameUtile.getAsName((String)annotationBinding.getEClass().getName()));
            if (allAnnotationsForName == null) {
                allAnnotationsForName = new LinkedHashMap<Annotation, Object[]>();
                allPartAnnotations.put(NameUtile.getAsName((String)annotationBinding.getEClass().getName()), allAnnotationsForName);
            }
            allAnnotationsForName.put(annotationBinding, new Object[]{field, targetDBinding});
        }
        return allAnnotationsMap;
    }

    private void runFieldContentRuleOnBindingAndChildren(FieldContentValidationRule rule, Member topLevelDBinding, Member dBinding, Node nodeForErrors, Node target, String canonicalContainerName, Map<String, Annotation> allAnnotationsMap, Map<String, Map<Annotation, Object[]>> allPartAnnotations, IProblemRequestor problemRequestor) {
        rule.validate(nodeForErrors, target, dBinding, canonicalContainerName, allAnnotationsMap, problemRequestor, this.compilerOptions);
        org.eclipse.edt.mof.egl.Type tBinding = dBinding.getType();
        if (tBinding != null) {
            this.runFieldContentRuleOnBindingAndChildren(rule, tBinding, topLevelDBinding, nodeForErrors, target, allPartAnnotations, problemRequestor);
        }
    }

    private void runFieldContentRuleOnBindingAndChildren(FieldContentValidationRule rule, org.eclipse.edt.mof.egl.Type tBinding, Member topLevelDBinding, Node nodeForErrors, Node target, Map<String, Map<Annotation, Object[]>> allPartAnnotations, IProblemRequestor problemRequestor) {
        if (tBinding instanceof Record) {
            for (Field nextChild : ((Record)tBinding).getFields()) {
                Map<String, Annotation> allAnnotationsMap = this.getAllAnnotationsMap(nextChild.getAnnotations(), allPartAnnotations, nodeForErrors, (Member)nextChild);
                this.runFieldContentRuleOnBindingAndChildren(rule, topLevelDBinding, (Member)nextChild, nodeForErrors, target, nextChild.getName(), allAnnotationsMap, allPartAnnotations, problemRequestor);
            }
        }
    }

    private Constructor getDefaultConstructor(org.eclipse.edt.mof.egl.Type type) {
        if (type.getClassifier() instanceof StructPart) {
            for (Constructor con : ((StructPart)type.getClassifier()).getConstructors()) {
                if (con.getParameters().size() != 0) continue;
                return con;
            }
        }
        return null;
    }
}

