/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class GetMethodAnnotationValueValidator
implements IValueValidationRule {
    private static final String getMethod = NameUtile.getAsName((String)"getMethod");

    @Override
    public void validate(Node errorNode, Node target, Annotation annotation, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotation.getValue(getMethod) instanceof Function) {
            this.validateGetMethod(errorNode, target, (Function)annotation.getValue(getMethod), BindingUtil.getDeclaringPart(target), problemRequestor, compilerOptions);
        }
    }

    public void validateGetMethod(Node errorNode, Node target, Function function, Part declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        Part valueDeclarer = BindingUtil.getDeclaringPart((Member)function);
        if (valueDeclarer != null && !valueDeclarer.equals((Type)declaringPart).booleanValue()) {
            problemRequestor.acceptProblem(errorNode, 3461, new String[]{"getMethod", declaringPart.getCaseSensitiveName()});
        }
        if (function.getParameters().size() > 0) {
            problemRequestor.acceptProblem(errorNode, 3385, new String[]{function.getCaseSensitiveName(), "getMethod"});
        }
        final Type[] fieldType = new Type[1];
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                fieldType[0] = classDataDeclaration.getType().resolveType();
                return false;
            }
        };
        target.accept(visitor);
        if (fieldType[0] != null && !fieldType[0].equals(function.getReturnType()).booleanValue()) {
            problemRequestor.acceptProblem(errorNode, 3386, new String[]{function.getCaseSensitiveName(), "getMethod", BindingUtil.getShortTypeString(fieldType[0])});
        }
    }
}

