/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ExpressionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public class ClassValidator
extends FunctionContainerValidator {
    IRPartBinding irBinding;
    EGLClass classBinding;
    Class clazz;

    public ClassValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, irBinding, compilerOptions);
        this.irBinding = irBinding;
        this.classBinding = (EGLClass)irBinding.getIrPart();
    }

    @Override
    public boolean visit(Class clazz) {
        this.clazz = clazz;
        this.partNode = clazz;
        EGLNameValidator.validate(clazz.getName(), 42, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(clazz);
        clazz.accept(new ExpressionValidator(this.partBinding, this.problemRequestor, this.compilerOptions));
        this.checkImplements(clazz.getImplementedInterfaces());
        this.checkInterfaceFunctionsOverriden((StructPart)this.classBinding);
        this.checkAbstractFunctionsOverriden((StructPart)this.classBinding);
        this.checkImplicitConstructor(clazz);
        if (this.checkExtends()) {
            this.checkCycles();
        }
        return true;
    }

    private boolean checkExtends() {
        Name extended = this.clazz.getExtends();
        if (extended != null) {
            Type type = extended.resolveType();
            if (type != null && !(type instanceof EGLClass)) {
                this.problemRequestor.acceptProblem((Node)extended, 3474, new String[]{type.getTypeSignature()});
                return false;
            }
            if (type != null && this.classBinding.equals(type).booleanValue()) {
                this.problemRequestor.acceptProblem((Node)extended, 3475, new String[]{type.getTypeSignature()});
                return false;
            }
        }
        return true;
    }

    private void checkCycles() {
        Type type;
        Name name = this.clazz.getExtends();
        if (name != null && (type = name.resolveType()) instanceof EGLClass && this.checkCycles((EGLClass)type, new HashSet<EGLClass>())) {
            this.problemRequestor.acceptProblem((Node)name, 5045, new String[]{this.classBinding.getCaseSensitiveName(), name.toString()});
        }
    }

    private boolean checkCycles(EGLClass classType, Set<EGLClass> seen) {
        if (seen.contains(classType = (EGLClass)BindingUtil.realize((Part)classType))) {
            return false;
        }
        if (this.classBinding.equals((Type)classType).booleanValue()) {
            return true;
        }
        seen.add(classType);
        for (StructPart superType : classType.getSuperTypes()) {
            if (!(superType instanceof EGLClass) || !this.checkCycles((EGLClass)superType, seen)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        Function override;
        Function function = (Function)nestedFunction.getName().resolveElement();
        if (function != null && (override = this.getOverriddenFunction(function, this.classBinding)) != null) {
            if (BindingUtil.isPrivate((Member)function) && !BindingUtil.isPrivate((Member)override)) {
                this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3013, new String[]{override.getCaseSensitiveName(), ((NamedElement)override.getContainer()).getCaseSensitiveName()});
            }
            if (!BindingUtil.typesAreIdentical(function.getReturnType(), override.getReturnType()) || function.isNullable() != override.isNullable()) {
                this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3014, new String[]{override.getCaseSensitiveName(), ((NamedElement)override.getContainer()).getCaseSensitiveName()});
            }
        }
        return super.visit(nestedFunction);
    }

    private Function getOverriddenFunction(Function function, EGLClass classBinding) {
        if (classBinding == null) {
            return null;
        }
        for (StructPart superType : classBinding.getSuperTypes()) {
            if (!(superType instanceof EGLClass)) continue;
            Function override = this.getOverriddenFunction(function, ((EGLClass)superType).getFunctions());
            if (override != null) {
                return override;
            }
            return this.getOverriddenFunction(function, (EGLClass)superType);
        }
        return null;
    }

    private Function getOverriddenFunction(Function function, List<Function> functions) {
        for (Function newFunc : functions) {
            if (!BindingUtil.functionSignituresAreIdentical(function, newFunc, false, false)) continue;
            return newFunc;
        }
        return null;
    }
}

