/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ExpressionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;

public class FlexibleRecordValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    IRPartBinding irBinding;
    Record recordBinding;
    private Name recordNameNode;
    private ICompilerOptions compilerOptions;

    public FlexibleRecordValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.irBinding = irBinding;
        this.recordBinding = (Record)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
        this.recordNameNode = record.getName();
        EGLNameValidator.validate(this.recordNameNode, 6, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(record);
        record.accept(new ExpressionValidator(this.irBinding, this.problemRequestor, this.compilerOptions));
        return true;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(structureItem);
        structureItem.accept(new FieldValidator(this.problemRequestor, this.compilerOptions, this.irBinding));
        TypeValidator.validateTypeDeclaration(structureItem.getType(), this.irBinding, this.problemRequestor);
        Type typeBinding = structureItem.getType().resolveType();
        if (typeBinding instanceof Record && this.containsReferenceTo((Record)typeBinding, this.recordBinding, new ArrayList<Record>())) {
            this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5057, new String[]{typeBinding.getTypeSignature()});
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    private boolean containsReferenceTo(Record mainRecord, Record recordToLookFor, List<Record> processedRecords) {
        for (Field f : mainRecord.getFields()) {
            Record currentRecord;
            Type t = f.getType();
            if (!(t instanceof Record) || !this.primContainsReferenceTo(recordToLookFor, processedRecords, currentRecord = (Record)BindingUtil.realize((Part)((Record)t)))) continue;
            return true;
        }
        return false;
    }

    private boolean primContainsReferenceTo(Record recordToLookFor, List<Record> processedRecords, Record currentRecord) {
        if (currentRecord.equals((Type)recordToLookFor).booleanValue()) {
            return true;
        }
        if (!processedRecords.contains(currentRecord)) {
            processedRecords.add(currentRecord);
            if (this.containsReferenceTo(currentRecord, recordToLookFor, processedRecords)) {
                return true;
            }
        }
        return false;
    }
}

