/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class InterfaceValidator
extends FunctionContainerValidator {
    IRPartBinding irBinding;
    private Interface interfaceBinding;
    protected org.eclipse.edt.compiler.core.ast.Interface iFaceNode;

    public InterfaceValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, irBinding, compilerOptions);
        this.irBinding = irBinding;
        this.interfaceBinding = (Interface)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Interface interfaceNode) {
        this.iFaceNode = interfaceNode;
        EGLNameValidator.validate(interfaceNode.getName(), 38, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(interfaceNode);
        if (this.iFaceNode.hasExtendedType()) {
            this.checkExtendedTypes();
            this.checkCycles();
        }
        return true;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        List<ASTValidator> validators = this.partBinding.getEnvironment().getCompiler().getValidatorsFor(nestedFunction);
        if (validators != null && validators.size() > 0) {
            for (ASTValidator validator : validators) {
                validator.validate(nestedFunction, (IRPartBinding)this.partBinding, this.problemRequestor, this.compilerOptions);
            }
        }
        if (nestedFunction.isPrivate()) {
            this.problemRequestor.acceptProblem(nestedFunction.getName(), 7810);
        }
        return false;
    }

    private void checkExtendedTypes() {
        for (Name nameAST : this.iFaceNode.getExtendedTypes()) {
            Type extendedType = nameAST.resolveType();
            if (extendedType == null || extendedType instanceof Interface) continue;
            this.problemRequestor.acceptProblem((Node)nameAST, 3427, new String[]{extendedType.getTypeSignature()});
        }
    }

    private void checkCycles() {
        for (Name name : this.iFaceNode.getExtendedTypes()) {
            Type type = name.resolveType();
            if (!(type instanceof Interface) || !this.checkCycles((Interface)type, new HashSet<Interface>())) continue;
            this.problemRequestor.acceptProblem((Node)name, 5045, new String[]{this.interfaceBinding.getCaseSensitiveName(), name.toString()});
        }
    }

    private boolean checkCycles(Interface iface, Set<Interface> seen) {
        if (seen.contains(iface = (Interface)BindingUtil.realize((Part)iface))) {
            return false;
        }
        if (this.interfaceBinding.equals((Type)iface).booleanValue()) {
            return true;
        }
        seen.add(iface);
        for (Interface superInterface : iface.getInterfaces()) {
            if (!this.checkCycles(superInterface, seen)) continue;
            return true;
        }
        return false;
    }
}

