/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ExpressionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.ServiceInterfaceValidatorUtil;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.StructPart;

public class ServiceValidator
extends FunctionContainerValidator {
    IRPartBinding irBinding;
    Service serviceBinding;
    protected org.eclipse.edt.compiler.core.ast.Service service;

    public ServiceValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, irBinding, compilerOptions);
        this.irBinding = irBinding;
        this.serviceBinding = (Service)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Service aservice) {
        this.service = aservice;
        this.partNode = aservice;
        EGLNameValidator.validate(this.service.getName(), 1, this.problemRequestor, this.compilerOptions);
        this.checkImplements(this.service.getImplementedInterfaces());
        this.checkInterfaceFunctionsOverriden((StructPart)this.serviceBinding);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(aservice);
        aservice.accept(new ExpressionValidator(this.partBinding, this.problemRequestor, this.compilerOptions));
        return true;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        ServiceInterfaceValidatorUtil.validateParametersAndReturn(nestedFunction, this.problemRequestor);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(nestedFunction);
        return false;
    }
}

