/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class AssignmentStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public AssignmentStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        Assignment assignment = assignmentStatement.getAssignment();
        Expression lhs = assignment.getLeftHandSide();
        Expression rhs = assignment.getRightHandSide();
        Type lhsType = lhs.resolveType();
        Type rhsType = rhs.resolveType();
        Member lhsMember = lhs.resolveMember();
        Member rhsMember = rhs.resolveMember();
        return this.validateAssignment(assignmentStatement.getAssignment().getOperator(), lhs, rhs, lhsType, rhsType, lhsMember, rhsMember);
    }

    public boolean validateAssignment(Assignment.Operator assignmentOperator, Expression lhs, Expression rhs, Type lhsType, Type rhsType, Member lhsMember, Member rhsMember) {
        return this.validateAssignment(assignmentOperator, lhs, rhs, lhsType, rhsType, lhsMember, rhsMember, new LValueValidator.DefaultLValueValidationRules());
    }

    public boolean validateAssignment(Assignment.Operator assignmentOperator, Expression lhs, Expression rhs, Type lhsType, Type rhsType, Member lhsMember, Member rhsMember, LValueValidator.ILValueValidationRules lvalueValidationRules) {
        if (lhs instanceof SubstringAccess) {
            this.problemRequestor.acceptProblem((Node)lhs, 6649, new String[0]);
        }
        if (lhsType != null) {
            HashMap<Object, Object> resolvedRHSMap = new HashMap();
            HashMap<Expression, Type> errors = new HashMap<Expression, Type>();
            HashMap<Expression, Type> exprMap = new HashMap<Expression, Type>();
            TypeValidator.collectExprsForTypeCompatibility(rhs, exprMap);
            if (assignmentOperator != Assignment.Operator.ASSIGN) {
                String symbol = assignmentOperator.toString().substring(0, assignmentOperator.toString().length() - 1);
                for (Map.Entry entry : exprMap.entrySet()) {
                    Operation op = IRUtils.getBinaryOperation((NamedElement)lhsType.getClassifier(), (NamedElement)(entry.getValue() == null ? ((Expression)entry.getKey()).resolveMember() : ((Type)entry.getValue()).getClassifier()), (String)symbol);
                    if (op != null) {
                        Type t;
                        boolean parmsValid = true;
                        if (BindingUtil.isUnresolvedGenericType(((FunctionParameter)op.getParameters().get(0)).getType())) {
                            t = BindingUtil.resolveGenericType(((FunctionParameter)op.getParameters().get(0)).getType(), lhsType);
                            parmsValid = BindingUtil.isMoveCompatible(t, (Member)op.getParameters().get(0), lhsType, lhs);
                        }
                        if (parmsValid && BindingUtil.isUnresolvedGenericType(((FunctionParameter)op.getParameters().get(1)).getType())) {
                            t = BindingUtil.resolveGenericType(((FunctionParameter)op.getParameters().get(1)).getType(), lhsType);
                            parmsValid = BindingUtil.isMoveCompatible(t, (Member)op.getParameters().get(1), (Type)entry.getValue(), (Expression)entry.getKey());
                        }
                        if (parmsValid) {
                            Type opType = op.getType();
                            if (BindingUtil.isUnresolvedGenericType(opType)) {
                                opType = BindingUtil.resolveGenericType(opType, lhsType);
                            }
                            resolvedRHSMap.put((Expression)entry.getKey(), opType);
                            continue;
                        }
                        errors.put((Expression)entry.getKey(), (Type)entry.getValue());
                        continue;
                    }
                    errors.put((Expression)entry.getKey(), (Type)entry.getValue());
                }
            } else {
                resolvedRHSMap = exprMap;
            }
            if (resolvedRHSMap.size() == 0 && !(rhsMember instanceof FunctionMember)) {
                if (rhsType != null) {
                    errors.put(rhs, rhsType);
                }
            } else {
                for (Map.Entry entry : resolvedRHSMap.entrySet()) {
                    if (BindingUtil.isMoveCompatible(lhsType, lhsMember, (Type)entry.getValue(), (Expression)entry.getKey())) continue;
                    errors.put((Expression)entry.getKey(), (Type)entry.getValue());
                }
            }
            for (Map.Entry entry : errors.entrySet()) {
                Type qualType;
                if (lhs instanceof ArrayAccess && TypeUtils.Type_NULLTYPE.equals((Type)entry.getValue()).booleanValue() && lhsMember != null && !lhsMember.isNullable() && (qualType = ((ArrayAccess)lhs).getArray().resolveType()) instanceof ArrayType && ((ArrayType)qualType).elementsNullable()) continue;
                this.problemRequestor.acceptProblem((Node)entry.getKey(), 6653, new String[]{lhsType != null ? BindingUtil.getShortTypeString(lhsType) : lhs.getCanonicalString(), BindingUtil.getShortTypeString((Expression)entry.getKey(), (Type)entry.getValue()), String.valueOf(lhs.getCanonicalString()) + " " + assignmentOperator.toString() + " " + ((Expression)entry.getKey()).getCanonicalString()});
            }
        }
        if (lhsMember != null) {
            if (assignmentOperator != Assignment.Operator.CONCAT) {
                new LValueValidator(this.problemRequestor, this.compilerOptions, lhsMember, lhs, lvalueValidationRules).validate();
            }
            if (assignmentOperator != Assignment.Operator.ASSIGN) {
                new RValueValidator(this.problemRequestor, this.compilerOptions, lhsMember, lhs).validate();
            }
        }
        if (rhsMember != null) {
            new RValueValidator(this.problemRequestor, this.compilerOptions, rhsMember, rhs).validate();
        }
        return false;
    }
}

