/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;

public class ClassDataDeclarationValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding declaringPart;

    public ClassDataDeclarationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding declaringPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.declaringPart = declaringPart;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        Iterator<Name> iter = classDataDeclaration.getNames().iterator();
        while (iter.hasNext()) {
            EGLNameValidator.validate(iter.next(), 1, this.problemRequestor, this.compilerOptions);
        }
        TypeValidator.validateTypeDeclaration(classDataDeclaration.getType(), this.declaringPart, this.problemRequestor);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(classDataDeclaration);
        classDataDeclaration.accept(new FieldValidator(this.problemRequestor, this.compilerOptions, this.declaringPart));
        if (classDataDeclaration.isStatic() && classDataDeclaration.hasInitializer()) {
            classDataDeclaration.getInitializer().accept(new FunctionContainerValidator.StaticReferenceChecker(this.problemRequestor));
        }
        return false;
    }
}

