/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;

public class ContinueStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private Map labeledLoops;

    public ContinueStatementValidator(IProblemRequestor problemRequestor, Map labeledLoops) {
        this.problemRequestor = problemRequestor;
        this.labeledLoops = labeledLoops;
    }

    @Override
    public boolean visit(final ContinueStatement continueStatement) {
        Node current = continueStatement.getParent();
        String label = continueStatement.getLabel();
        ParentASTVisitor visitor = new ParentASTVisitor(this.isContinueNULL(continueStatement), label){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                this.bcontinue = false;
                return false;
            }

            @Override
            public boolean visit(WhileStatement whileStatement) {
                if (continueStatement.isContinueWhile() || this.isnull || this.hasMatchingLabel(whileStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(ForEachStatement forEachStatement) {
                if (continueStatement.isContinueForEach() || this.isnull || this.hasMatchingLabel(forEachStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(ForStatement forStatement) {
                if (continueStatement.isContinueFor() || this.isnull || this.hasMatchingLabel(forStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }
        };
        while (current != null && visitor.canContinue() && !visitor.isValid()) {
            current.accept(visitor);
            current = current.getParent();
        }
        if (!visitor.isValid()) {
            if (visitor.isnull()) {
                this.problemRequestor.acceptProblem(continueStatement, 5054);
            } else {
                String errorIns0 = "continue";
                String errorIns1 = "";
                String[] errorInserts = null;
                boolean isLabel = false;
                if (continueStatement.isContinueFor()) {
                    errorIns1 = "for";
                } else if (continueStatement.isContinueForEach()) {
                    errorIns1 = "forEach";
                } else if (continueStatement.isContinueWhile()) {
                    errorIns1 = "while";
                } else {
                    isLabel = true;
                }
                if (isLabel) {
                    this.problemRequestor.acceptProblem((Node)continueStatement, 5056, new String[]{continueStatement.getLabel()});
                } else {
                    errorInserts = new String[]{errorIns0, errorIns1};
                    this.problemRequestor.acceptProblem((Node)continueStatement, 5055, errorInserts);
                }
            }
        }
        return false;
    }

    protected boolean isContinueNULL(ContinueStatement continueStatement) {
        return !continueStatement.isContinueFor() && !continueStatement.isContinueForEach() && !continueStatement.isContinueWhile() && continueStatement.getLabel() == null;
    }

    private class ParentASTVisitor
    extends DefaultASTVisitor {
        boolean valid = false;
        boolean bcontinue = true;
        boolean isnull = false;
        String labelText;

        public ParentASTVisitor(boolean isnull, String labelText) {
            this.isnull = isnull;
            this.labelText = labelText;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean canContinue() {
            return this.bcontinue;
        }

        public boolean isnull() {
            return this.isnull;
        }

        protected boolean hasMatchingLabel(Statement loopStatement, String labelText) {
            LabelStatement label = (LabelStatement)ContinueStatementValidator.this.labeledLoops.get(loopStatement);
            if (label != null) {
                return label.getLabel().equalsIgnoreCase(labelText);
            }
            return false;
        }
    }
}

