/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.mof.egl.Annotation;

public class FieldValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding declaringPart;

    public FieldValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding declaringPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.declaringPart = declaringPart;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        Type type = classDataDeclaration.getType();
        TypeValidator.validate(classDataDeclaration.getType(), this.declaringPart, this.problemRequestor, this.compilerOptions);
        if (classDataDeclaration.hasInitializer()) {
            this.validateInitializer(classDataDeclaration.getNames().get(0), classDataDeclaration.getInitializer());
            if (classDataDeclaration.hasSettingsBlock()) {
                this.issueErrorForInitialization(classDataDeclaration.getSettingsBlockOpt(), classDataDeclaration.getNames().get(0).getCanonicalName(), 3436);
            }
        } else {
            TypeValidator.validateInstantiatable(type, this.declaringPart, classDataDeclaration.isNullable(), this.problemRequestor);
            if (classDataDeclaration.hasSettingsBlock() && classDataDeclaration.isNullable()) {
                this.issueErrorForInitialization(classDataDeclaration.getSettingsBlockOpt(), classDataDeclaration.getNames().get(0).getCanonicalName(), 3437);
            }
        }
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        Type type = functionDataDeclaration.getType();
        if (type != null) {
            TypeValidator.validate(type, this.declaringPart, this.problemRequestor, this.compilerOptions);
            if (functionDataDeclaration.hasInitializer()) {
                this.validateInitializer(functionDataDeclaration.getNames().get(0), functionDataDeclaration.getInitializer());
                if (functionDataDeclaration.hasSettingsBlock()) {
                    this.issueErrorForInitialization(functionDataDeclaration.getSettingsBlockOpt(), functionDataDeclaration.getNames().get(0).getCanonicalName(), 3436);
                }
            } else {
                TypeValidator.validateInstantiatable(type, this.declaringPart, functionDataDeclaration.isNullable(), this.problemRequestor);
                if (functionDataDeclaration.hasSettingsBlock() && functionDataDeclaration.isNullable()) {
                    this.issueErrorForInitialization(functionDataDeclaration.getSettingsBlockOpt(), functionDataDeclaration.getNames().get(0).getCanonicalName(), 3437);
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        Type type = structureItem.getType();
        if (type != null) {
            TypeValidator.validate(type, this.declaringPart, this.problemRequestor, this.compilerOptions);
            if (structureItem.hasInitializer()) {
                this.validateInitializer(structureItem.getName(), structureItem.getInitializer());
                if (structureItem.hasSettingsBlock() && structureItem.getName() != null) {
                    this.issueErrorForInitialization(structureItem.getSettingsBlock(), structureItem.getName().getCanonicalName(), 3436);
                }
            }
            if (!structureItem.hasInitializer()) {
                TypeValidator.validateInstantiatable(type, this.declaringPart, structureItem.isNullable(), this.problemRequestor);
                if (structureItem.hasSettingsBlock() && structureItem.isNullable() && structureItem.getName() != null) {
                    this.issueErrorForInitialization(structureItem.getSettingsBlock(), structureItem.getName().getCanonicalName(), 3437);
                }
            }
        }
        return false;
    }

    private void validateInitializer(Name name, Expression initializer) {
        if (initializer != null && name != null) {
            new AssignmentStatementValidator(this.problemRequestor, this.compilerOptions, this.declaringPart).validateAssignment(Assignment.Operator.ASSIGN, name, initializer, name.resolveType(), initializer.resolveType(), name.resolveMember(), initializer.resolveMember(), new LValueValidator.DefaultLValueValidationRules(){

                @Override
                public boolean canAssignToConstantVariables() {
                    return true;
                }
            });
        }
    }

    private void issueErrorForInitialization(SettingsBlock settings, String fieldName, int errorNo) {
        final Node[] errorNode = new Node[1];
        settings.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                Object dBinding;
                if (errorNode[0] != null) {
                    return false;
                }
                if (assignment.resolveBinding() == null && (dBinding = assignment.getLeftHandSide().resolveElement()) != null && !(dBinding instanceof Annotation)) {
                    errorNode[0] = assignment;
                }
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                if (errorNode[0] != null) {
                    return false;
                }
                Object dBinding = setValuesExpression.getExpression().resolveElement();
                if (dBinding != null && !(dBinding instanceof Annotation)) {
                    setValuesExpression.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                if (errorNode[0] != null) {
                    return false;
                }
                errorNode[0] = expression;
                return false;
            }
        });
        if (errorNode[0] != null) {
            this.problemRequestor.acceptProblem(errorNode[0], errorNo, 2, new String[]{fieldName});
        }
    }
}

