/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Type;

public class ForEachStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;

    public ForEachStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        Expression source = forEachStatement.getResultSet().getExpression();
        Type sourceType = source.resolveType();
        if (sourceType != null && sourceType instanceof ArrayType) {
            sourceType = BindingUtil.resolveGenericType(sourceType, source);
            if (!forEachStatement.hasVariableDeclaration()) {
                this.problemRequestor.acceptProblem((Node)forEachStatement, 5037, new String[0]);
            } else {
                Type targetType = forEachStatement.getVariableDeclarationType().resolveType();
                Type elementType = ((ArrayType)sourceType).getElementType();
                if (targetType != null && !BindingUtil.isMoveCompatible(targetType, forEachStatement.getVariableDeclarationName().resolveMember(), elementType, source)) {
                    this.problemRequestor.acceptProblem((Node)source, 6653, new String[]{BindingUtil.getShortTypeString(targetType), BindingUtil.getShortTypeString(source, sourceType), forEachStatement.toString()});
                }
            }
        } else if (sourceType != null) {
            this.problemRequestor.acceptProblem((Node)source, 5038, new String[]{source.getCanonicalString()});
        }
        return false;
    }
}

