/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;

public class FunctionDataDeclarationValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public FunctionDataDeclarationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        Iterator<Name> iter = functionDataDeclaration.getNames().iterator();
        while (iter.hasNext()) {
            EGLNameValidator.validate(iter.next(), 1, this.problemRequestor, this.compilerOptions);
        }
        TypeValidator.validateTypeDeclaration(functionDataDeclaration.getType(), this.enclosingPart, this.problemRequestor);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(functionDataDeclaration);
        functionDataDeclaration.accept(new FieldValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        return false;
    }
}

