/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.FieldAccessValidationRule;
import org.eclipse.edt.compiler.binding.IValidationProxy;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.utils.NameUtile;

public class RValueValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private Member member;
    private Expression nodeForErrors;

    public RValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, Member member, Expression nodeForErrors) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.member = member;
        this.nodeForErrors = nodeForErrors;
    }

    public boolean validate() {
        boolean result = true;
        if (this.member == null) {
            return result;
        }
        if (!this.checkFunctionDelegation()) {
            result = false;
        }
        if (!this.invokeFieldAccessValidators()) {
            result = false;
        }
        return result;
    }

    private boolean invokeFieldAccessValidators() {
        boolean result = true;
        for (Annotation annot : this.member.getAnnotations()) {
            IValidationProxy proxy = AnnotationValidator.getValidationProxy(annot);
            if (proxy == null) continue;
            for (FieldAccessValidationRule rule : proxy.getFieldAccessValidators()) {
                boolean bl = result = rule.validateRValue(this.nodeForErrors, this.member, this.problemRequestor, this.compilerOptions) && result;
            }
        }
        return result;
    }

    private boolean checkFunctionDelegation() {
        Part declaringPart;
        boolean result = true;
        if (this.member instanceof FunctionMember && (declaringPart = BindingUtil.getDeclaringPart(this.member)) instanceof Program && NameUtile.equals((String)this.member.getName(), (String)NameUtile.getAsName((String)"main"))) {
            this.problemRequestor.acceptProblem((Node)this.nodeForErrors, 3418, new String[]{this.member.getCaseSensitiveName()});
            result = false;
        }
        return result;
    }
}

