/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.ThrowStatementValidator;
import org.eclipse.edt.mof.egl.Type;

public class TryStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;
    private Set caughtExceptionTypes = new HashSet();

    public TryStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        Iterator<Node> iter = tryStatement.getOnExceptionBlocks().iterator();
        while (iter.hasNext()) {
            ((OnExceptionBlock)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        org.eclipse.edt.compiler.core.ast.Type exceptionType;
        Type exceptionTypeBinding;
        if (this.enclosingPart != null && (exceptionTypeBinding = (exceptionType = onExceptionBlock.getExceptionType()).resolveType()) != null) {
            if (this.caughtExceptionTypes.contains(exceptionTypeBinding)) {
                this.problemRequestor.acceptProblem((Node)exceptionType, 3441, new String[]{exceptionType.getCanonicalName()});
            } else if (!ThrowStatementValidator.isAnyException(exceptionTypeBinding)) {
                this.problemRequestor.acceptProblem((Node)exceptionType, 3440, new String[]{exceptionType.getCanonicalName()});
            } else {
                this.caughtExceptionTypes.add(exceptionTypeBinding);
            }
        }
        return false;
    }
}

