/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.Type;

public class UseStatementValidator
extends DefaultASTVisitor {
    private IPartBinding parent;
    private String canonicalParentName;
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public UseStatementValidator(IPartBinding binding, String canonicalParentName, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.parent = binding;
        this.problemRequestor = problemRequestor;
        this.canonicalParentName = canonicalParentName;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(final UseStatement useStatement) {
        if (this.parent == null || useStatement.getNames().size() == 0) {
            return false;
        }
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(useStatement);
        useStatement.getParent().accept(new AbstractASTPartVisitor(){

            @Override
            public boolean visit(Service service) {
                this.validateUseTypes("service");
                return false;
            }

            @Override
            public boolean visit(Handler handler) {
                this.validateUseTypes("handler");
                return false;
            }

            @Override
            public boolean visit(Class eglClass) {
                this.validateUseTypes("class");
                return false;
            }

            @Override
            public boolean visit(Program program) {
                this.validateUseTypes("program");
                return false;
            }

            @Override
            public boolean visit(Library library) {
                this.validateUseTypes("library");
                return false;
            }

            private void validateUseTypes(String type) {
                for (Name name : useStatement.getNames()) {
                    Type typeBinding = name.resolveType();
                    if (typeBinding == null || typeBinding instanceof Enumeration || typeBinding instanceof org.eclipse.edt.mof.egl.Library) continue;
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)name, 4930, new String[]{name.getCanonicalName(), type, UseStatementValidator.this.canonicalParentName});
                }
            }

            @Override
            public void visitPart(Part part) {
            }
        });
        return false;
    }
}

