/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.eglar;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.eclipse.edt.compiler.internal.eglar.EglarFile;
import org.eclipse.edt.compiler.internal.eglar.EglarFileCache;

public class FileInEglar {
    public static final String EGLAR_PREFIX = "eglar://";
    public static final String EGLAR_SEPARATOR = "|";
    public static final String EGLAR_EXTENSION = ".eglar";
    private EglarFile eglarFile;
    private ZipEntry entry;

    public FileInEglar(String path) {
        if (path.startsWith(EGLAR_PREFIX)) {
            try {
                int index = path.indexOf(EGLAR_SEPARATOR);
                this.eglarFile = EglarFileCache.instance.getEglarFile(path.substring(8, index));
                this.entry = new ZipEntry(path.substring(index + 1));
            }
            catch (IOException iOException) {}
        }
    }

    public EglarFile getEglarFile() {
        return this.eglarFile;
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    public boolean exists() {
        return this.eglarFile != null && this.entry != null;
    }

    public InputStream getInputStream() throws IOException {
        return this.eglarFile.getInputStream(this.entry);
    }

    public String getFullPath(boolean withProtocol) {
        return String.valueOf(withProtocol ? EGLAR_PREFIX : "") + this.eglarFile.getName() + EGLAR_SEPARATOR + this.entry.getName();
    }

    public String getEglarPath() {
        return this.eglarFile.getName();
    }

    public String getEntryPath() {
        return this.entry.getName();
    }
}

