/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.edt.compiler.PartEnvironmentStack;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.TernaryExpression;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Class;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DataItem;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.EClassProxy;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ElementKind;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.PatternType;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.utils.NameUtile;

public class BindingUtil {
    private static final String INVALID_ANNOTATION = "edt invalid";
    public static final String ENVIRONMENT_ANNOTATION = "edt environment";
    private static Annotation ValidAnn;
    private static Map<Type, WeakReference<ArrayType>> typeBindingsToArrayTypes;
    private static Map<Type, WeakReference<ArrayType>> typeBindingsToArrayTypesNullable;
    private static Map<String, PackageAndPartName> aliasedTypesNames;

    static {
        typeBindingsToArrayTypes = new WeakHashMap<Type, WeakReference<ArrayType>>();
        typeBindingsToArrayTypesNullable = new WeakHashMap<Type, WeakReference<ArrayType>>();
        aliasedTypesNames = new HashMap<String, PackageAndPartName>();
        aliasedTypesNames.put(NameUtile.getAsName((String)"any"), new PackageAndPartName("eglx.lang", "EAny"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"bigint"), new PackageAndPartName("eglx.lang", "EBigint"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"boolean"), new PackageAndPartName("eglx.lang", "EBoolean"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"bytes"), new PackageAndPartName("eglx.lang", "EBytes"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"date"), new PackageAndPartName("eglx.lang", "EDate"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"decimal"), new PackageAndPartName("eglx.lang", "EDecimal"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"dictionary"), new PackageAndPartName("eglx.lang", "EDictionary"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"float"), new PackageAndPartName("eglx.lang", "EFloat"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"int"), new PackageAndPartName("eglx.lang", "EInt"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"number"), new PackageAndPartName("eglx.lang", "ENumber"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"smallfloat"), new PackageAndPartName("eglx.lang", "ESmallfloat"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"smallint"), new PackageAndPartName("eglx.lang", "ESmallint"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"string"), new PackageAndPartName("eglx.lang", "EString"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"timestamp"), new PackageAndPartName("eglx.lang", "ETimestamp"));
        aliasedTypesNames.put(NameUtile.getAsName((String)"time"), new PackageAndPartName("eglx.lang", "ETime"));
    }

    public static boolean isValid(org.eclipse.edt.mof.egl.Part part) {
        return part != null && part.getAnnotation(INVALID_ANNOTATION) == null;
    }

    private static Annotation getInvalidAnn() {
        if (ValidAnn == null) {
            ValidAnn = BindingUtil.createInvalidAnn();
        }
        return ValidAnn;
    }

    private static Annotation createInvalidAnn() {
        return BindingUtil.createAnnotation(INVALID_ANNOTATION);
    }

    private static Annotation createAnnotation(String name) {
        Annotation ann = IrFactory.INSTANCE.createDynamicAnnotation(name);
        return ann;
    }

    public static void setValid(org.eclipse.edt.mof.egl.Part part, boolean value) {
        Annotation ann = part.getAnnotation(INVALID_ANNOTATION);
        if (value) {
            if (ann == null) {
                return;
            }
            part.removeAnnotation(ann);
        } else if (ann == null) {
            part.addAnnotation(BindingUtil.getInvalidAnn());
        }
    }

    public static String getLastSegment(String str) {
        int index;
        if (str == null) {
            str = "";
        }
        if ((index = str.lastIndexOf(".")) < 0) {
            return str;
        }
        return str.substring(index + 1);
    }

    public static String removeLastSegment(String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return str.substring(0, index);
    }

    public static IRPartBinding createPartBinding(EObject obj) {
        if (obj instanceof org.eclipse.edt.mof.egl.Part) {
            return new IRPartBinding((org.eclipse.edt.mof.egl.Part)obj);
        }
        return null;
    }

    public static int getPartTypeConstant(org.eclipse.edt.mof.egl.Part part) {
        if (part instanceof Delegate) {
            return 27;
        }
        if (part instanceof ExternalType) {
            return 28;
        }
        if (part instanceof StereotypeType) {
            return 31;
        }
        if (part instanceof AnnotationType) {
            return 18;
        }
        if (part instanceof Record) {
            return 7;
        }
        if (part instanceof Handler) {
            return 10;
        }
        if (part instanceof Interface) {
            return 15;
        }
        if (part instanceof Library) {
            return 11;
        }
        if (part instanceof Program) {
            return 13;
        }
        if (part instanceof Service) {
            return 14;
        }
        if (part instanceof DataItem) {
            return 17;
        }
        if (part instanceof FunctionPart) {
            return 20;
        }
        if (part instanceof Enumeration) {
            return 19;
        }
        if (part instanceof EGLClass) {
            return 30;
        }
        return -1;
    }

    public static IPartBinding createPartBinding(int type, PackageAndPartName ppName) {
        IPartBinding partBinding = BindingUtil.primCreatePartBinding(type, ppName.getCaseSensitivePackageName(), ppName.getCaseSensitivePartName());
        if (partBinding instanceof IRPartBinding) {
            BindingUtil.setValid(((IRPartBinding)partBinding).getIrPart(), false);
        }
        return partBinding;
    }

    private static IPartBinding primCreatePartBinding(int type, String pkgName, String name) {
        switch (type) {
            case 16: {
                return new FileBinding(pkgName, name);
            }
            case 27: {
                Delegate part = BindingUtil.createDelegate(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 28: {
                ExternalType part = BindingUtil.createExternalType(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 7: {
                Record part = BindingUtil.createRecord(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 10: {
                Handler part = BindingUtil.createHandler(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 15: {
                Interface part = BindingUtil.createInterface(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 11: {
                Library part = BindingUtil.createLibrary(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 13: {
                Program part = BindingUtil.createProgram(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 14: {
                Service part = BindingUtil.createService(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 17: {
                DataItem part = BindingUtil.createDataItem(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 20: {
                FunctionPart part = BindingUtil.createFunction(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 19: {
                Enumeration part = BindingUtil.createEnumeration(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 30: {
                Class part = BindingUtil.createClass(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 18: {
                AnnotationType part = BindingUtil.createAnnotationType(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
            case 31: {
                StereotypeType part = BindingUtil.createStereotypeType(pkgName, name);
                return BindingUtil.createPartBinding((EObject)part);
            }
        }
        throw new RuntimeException("Unsupported kind: " + type);
    }

    private static AnnotationType createAnnotationType(String pkgName, String name) {
        AnnotationType annType = IrFactory.INSTANCE.createAnnotationType();
        annType.setName(name);
        annType.setPackageName(pkgName);
        return annType;
    }

    private static StereotypeType createStereotypeType(String pkgName, String name) {
        StereotypeType sterType = IrFactory.INSTANCE.createStereotypeType();
        sterType.setName(name);
        sterType.setPackageName(pkgName);
        return sterType;
    }

    private static Program createProgram(String pkgName, String name) {
        Program pgm = IrFactory.INSTANCE.createProgram();
        pgm.setName(name);
        pgm.setPackageName(pkgName);
        return pgm;
    }

    private static Library createLibrary(String pkgName, String name) {
        Library lib = IrFactory.INSTANCE.createLibrary();
        lib.setName(name);
        lib.setPackageName(pkgName);
        return lib;
    }

    private static Handler createHandler(String pkgName, String name) {
        Handler hnd = IrFactory.INSTANCE.createHandler();
        hnd.setName(name);
        hnd.setPackageName(pkgName);
        return hnd;
    }

    private static ExternalType createExternalType(String pkgName, String name) {
        ExternalType ext = IrFactory.INSTANCE.createExternalType();
        ext.setName(name);
        ext.setPackageName(pkgName);
        return ext;
    }

    private static Service createService(String pkgName, String name) {
        Service ser = IrFactory.INSTANCE.createService();
        ser.setName(name);
        ser.setPackageName(pkgName);
        return ser;
    }

    private static Class createClass(String pkgName, String name) {
        Class clazz = IrFactory.INSTANCE.createClass();
        clazz.setName(name);
        clazz.setPackageName(pkgName);
        return clazz;
    }

    private static Enumeration createEnumeration(String pkgName, String name) {
        Enumeration enm = IrFactory.INSTANCE.createEnumeration();
        enm.setName(name);
        enm.setPackageName(pkgName);
        return enm;
    }

    private static Record createRecord(String pkgName, String name) {
        Record rcd = IrFactory.INSTANCE.createRecord();
        rcd.setName(name);
        rcd.setPackageName(pkgName);
        return rcd;
    }

    private static Delegate createDelegate(String pkgName, String name) {
        Delegate del = IrFactory.INSTANCE.createDelegate();
        del.setName(name);
        del.setPackageName(pkgName);
        return del;
    }

    private static Interface createInterface(String pkgName, String name) {
        Interface inf = IrFactory.INSTANCE.createInterface();
        inf.setName(name);
        inf.setPackageName(pkgName);
        return inf;
    }

    private static DataItem createDataItem(String pkgName, String name) {
        DataItem dti = IrFactory.INSTANCE.createDataItem();
        dti.setName(name);
        dti.setPackageName(pkgName);
        return dti;
    }

    private static FunctionPart createFunction(String pkgName, String name) {
        FunctionPart fun = IrFactory.INSTANCE.createFunctionPart();
        fun.setName(name);
        fun.setPackageName(pkgName);
        return fun;
    }

    public static org.eclipse.edt.mof.egl.Part findPart(String pkgName, String name) {
        IPartBinding partBinding = PartEnvironmentStack.getCurrentEnv().getPartBinding(pkgName, name);
        return BindingUtil.getPart(partBinding);
    }

    public static org.eclipse.edt.mof.egl.Part getPart(IPartBinding partBinding) {
        if (partBinding == null) {
            return null;
        }
        if (!(partBinding instanceof IRPartBinding)) {
            return null;
        }
        return ((IRPartBinding)partBinding).getIrPart();
    }

    public static AnnotationType getAnnotationType(String pkgName, String name) {
        org.eclipse.edt.mof.egl.Part part = BindingUtil.findPart(pkgName, name);
        if (part instanceof AnnotationType) {
            return (AnnotationType)part;
        }
        return null;
    }

    public static AnnotationType getAnnotationType(Type type) {
        if (type instanceof AnnotationType) {
            return (AnnotationType)type;
        }
        return null;
    }

    public static org.eclipse.edt.mof.egl.Part realize(org.eclipse.edt.mof.egl.Part part) {
        if (BindingUtil.isValid(part)) {
            return part;
        }
        return BindingUtil.findPart(part.getPackageName(), part.getName());
    }

    public static boolean functionSignituresAreIdentical(Function function1, Function function2) {
        return BindingUtil.functionSignituresAreIdentical(function1, function2, true, true);
    }

    public static boolean functionSignituresAreIdentical(Function function1, Function function2, boolean includeReturnTypeInSignature, boolean includeParameterModifiersInSignature) {
        if (!NameUtile.equals((String)function1.getName(), (String)function2.getName())) {
            return false;
        }
        return BindingUtil.functionSignituresAreIdentical(new FunctionSignature(function1), new FunctionSignature(function2), includeReturnTypeInSignature, includeParameterModifiersInSignature);
    }

    public static boolean functionSignituresAreIdentical(IFunctionSignature fSignature1, IFunctionSignature fSignature2) {
        return BindingUtil.functionSignituresAreIdentical(fSignature1, fSignature2, true, true);
    }

    public static boolean functionSignituresAreIdentical(IFunctionSignature fSignature1, IFunctionSignature fSignature2, boolean includeReturnTypeInSignature, boolean includeParameterModifiersInSignature) {
        List<FunctionParameter> parameters1 = fSignature1.getParameters();
        List<FunctionParameter> parameters2 = fSignature2.getParameters();
        if (parameters1.size() != parameters2.size()) {
            return false;
        }
        int i = 0;
        while (i < parameters1.size()) {
            FunctionParameter parm1 = parameters1.get(i);
            FunctionParameter parm2 = parameters2.get(i);
            if (includeParameterModifiersInSignature) {
                if (parm1.getParameterKind() != parm2.getParameterKind()) {
                    return false;
                }
                if (parm1.isConst() != parm2.isConst()) {
                    return false;
                }
                if (parm1.isField() != parm2.isField()) {
                    return false;
                }
                if (parm1.isNullable() != parm2.isNullable()) {
                    return false;
                }
            }
            if (!BindingUtil.typesAreIdentical(parm1.getType(), parm2.getType())) {
                return false;
            }
            ++i;
        }
        if (includeReturnTypeInSignature) {
            Type returnType1 = fSignature1.getReturnType();
            Type returnType2 = fSignature2.getReturnType();
            if (returnType1 == null) {
                if (returnType2 != null) {
                    return false;
                }
            } else {
                if (returnType2 == null) {
                    return false;
                }
                if (!BindingUtil.typesAreIdentical(returnType1, returnType2)) {
                    return false;
                }
                if (fSignature1.isReturnNullable() != fSignature2.isReturnNullable()) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean typesAreIdentical(Type type1, Type type2) {
        if (type1 == null && type2 == null) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.equals(type2);
    }

    public static boolean isApplicableFor(AnnotationType annType, Element elem) {
        annType = (AnnotationType)BindingUtil.realize((org.eclipse.edt.mof.egl.Part)annType);
        return BindingUtil.isApplicableFor(elem, annType.getTargets());
    }

    public static boolean isApplicableFor(Element targetBinding, List<ElementKind> targets) {
        ElementKind targetType = BindingUtil.getElementKind(targetBinding);
        return BindingUtil.isApplicableFor(targetType, targets, targetBinding instanceof org.eclipse.edt.mof.egl.Part);
    }

    public static boolean isApplicableFor(ElementKind targetType, List<ElementKind> targets, boolean targetIsPart) {
        if (targetType == null) {
            return false;
        }
        String targetTypeName = NameUtile.getAsName((String)targetType.name());
        for (ElementKind nextTarget : targets) {
            String nextTargetName = null;
            if (nextTarget instanceof ElementKind) {
                if (targetType == nextTarget) {
                    return true;
                }
                nextTargetName = NameUtile.getAsName((String)nextTarget.name());
            } else if (nextTarget instanceof EEnumLiteral && NameUtile.equals((String)(nextTargetName = NameUtile.getAsName((String)((EEnumLiteral)nextTarget).getName())), (String)targetTypeName)) {
                return true;
            }
            if (!targetIsPart || !NameUtile.equals((String)nextTargetName, (String)NameUtile.getAsName((String)"part"))) continue;
            return true;
        }
        return false;
    }

    public static ElementKind getElementKind(Element elem) {
        if (elem instanceof Record) {
            return ElementKind.RecordPart;
        }
        if (elem instanceof Program) {
            return ElementKind.ProgramPart;
        }
        if (elem instanceof Library) {
            return ElementKind.LibraryPart;
        }
        if (elem instanceof Handler) {
            return ElementKind.HandlerPart;
        }
        if (elem instanceof Interface) {
            return ElementKind.InterfacePart;
        }
        if (elem instanceof Service) {
            return ElementKind.ServicePart;
        }
        if (elem instanceof ExternalType) {
            return ElementKind.ExternalTypePart;
        }
        if (elem instanceof Delegate) {
            return ElementKind.DelegatePart;
        }
        if (elem instanceof Enumeration) {
            return ElementKind.EnumerationPart;
        }
        if (elem instanceof EnumerationEntry) {
            return ElementKind.EnumerationEntry;
        }
        if (elem instanceof Field) {
            return ElementKind.FieldMbr;
        }
        if (elem instanceof Constructor) {
            return ElementKind.ConstructorMbr;
        }
        if (elem instanceof Function) {
            return ElementKind.FunctionMbr;
        }
        if (elem instanceof EGLClass) {
            return ElementKind.ClassPart;
        }
        if (elem instanceof AnnotationType) {
            return ElementKind.RecordPart;
        }
        return null;
    }

    public static Type getBaseType(Type type) {
        if (type instanceof ArrayType) {
            return BindingUtil.getBaseType(((ArrayType)type).getElementType());
        }
        return type;
    }

    public static List<Member> findPublicMembers(Type type, String id) {
        if (type instanceof Container) {
            ArrayList<Member> list = new ArrayList<Member>();
            for (Member mbr : ((Container)type).getAllMembers()) {
                if (!NameUtile.equals((String)id, (String)mbr.getId()) || BindingUtil.isPrivate(mbr)) continue;
                list.add(mbr);
                if (!(mbr instanceof Field)) continue;
                return list;
            }
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
        return null;
    }

    public static List<Member> findMembers(Type type, String id) {
        if (type instanceof Container) {
            ArrayList<Member> list = new ArrayList<Member>();
            for (Member mbr : ((Container)type).getAllMembers()) {
                if (!NameUtile.equals((String)id, (String)mbr.getId())) continue;
                list.add(mbr);
                if (!(mbr instanceof Field)) continue;
                return list;
            }
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
        return null;
    }

    public static List<Field> getAllFields(Type type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type instanceof Container) {
            for (Member mbr : ((Container)type).getAllMembers()) {
                if (!(mbr instanceof Field)) continue;
                fields.add((Field)mbr);
            }
        }
        return fields;
    }

    public static List<Function> getAllFunctions(Type type) {
        ArrayList<Function> functions = new ArrayList<Function>();
        if (type instanceof Container) {
            for (Member mbr : ((Container)type).getAllMembers()) {
                if (!(mbr instanceof Function)) continue;
                functions.add((Function)mbr);
            }
        }
        return functions;
    }

    public static ArrayType getArrayType(Type elemType, boolean nullable) {
        Map<Type, WeakReference<ArrayType>> map = nullable ? typeBindingsToArrayTypesNullable : typeBindingsToArrayTypes;
        WeakReference<ArrayType> result = map.get(elemType);
        if (result == null || result.get() == null) {
            ArrayType newArray = IrFactory.INSTANCE.createArrayType();
            newArray.setElementType(elemType);
            newArray.setElementsNullable(nullable);
            newArray.setClassifier((Classifier)TypeUtils.Type_LIST);
            result = new WeakReference<ArrayType>(newArray);
            map.put(elemType, result);
        }
        return (ArrayType)result.get();
    }

    public static Type findAliasedType(String name) {
        PackageAndPartName ppn = aliasedTypesNames.get(name);
        if (ppn == null) {
            return null;
        }
        return IRUtils.getEGLType((String)(String.valueOf(ppn.getPackageName()) + "." + ppn.getPartName()));
    }

    public static String getUnaliasedTypeName(Type type, boolean includeParams) {
        if (type == null) {
            return "";
        }
        if (type.equals(TypeUtils.Type_NULLTYPE).booleanValue()) {
            return "null";
        }
        Classifier classifier = type.getClassifier();
        String unaliasedName = null;
        if (classifier != null) {
            String pkg = NameUtile.getAsName((String)classifier.getPackageName());
            String name = NameUtile.getAsName((String)classifier.getName());
            for (Map.Entry<String, PackageAndPartName> entry : aliasedTypesNames.entrySet()) {
                String sig;
                int paren;
                PackageAndPartName value = entry.getValue();
                if (!NameUtile.equals((String)value.getPackageName(), (String)pkg) || !NameUtile.equals((String)value.getPartName(), (String)name)) continue;
                unaliasedName = entry.getKey();
                if (!includeParams || !(type instanceof ParameterizedType) || (paren = (sig = type.getTypeSignature()).indexOf("(")) == -1) break;
                unaliasedName = String.valueOf(unaliasedName) + sig.substring(paren);
                break;
            }
        }
        if (!includeParams && unaliasedName == null && type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getParameterizableType();
        }
        if (unaliasedName == null) {
            unaliasedName = type.getTypeSignature();
        }
        if (type instanceof ParameterizedType) {
            int closeParen;
            int paren = unaliasedName.indexOf("(");
            if (paren != -1) {
                unaliasedName = unaliasedName.replaceAll(":", ",");
            }
            if (type instanceof PatternType && paren != -1 && (closeParen = unaliasedName.indexOf(")")) != -1) {
                unaliasedName = String.valueOf(unaliasedName.substring(0, paren + 1)) + "\"" + unaliasedName.substring(paren + 1, closeParen) + "\"" + unaliasedName.substring(closeParen);
            }
        }
        return unaliasedName;
    }

    public static String getTypeString(Type binding, boolean includeParams) {
        StringBuilder result = new StringBuilder();
        if (binding instanceof ArrayType) {
            result.append(BindingUtil.getTypeString(((ArrayType)binding).getElementType(), includeParams));
            if (((ArrayType)binding).elementsNullable()) {
                result.append('?');
            }
            result.append("[]");
        } else if (binding instanceof AnnotationType) {
            result.append('@');
            result.append(binding.getTypeSignature());
        } else if (binding != null) {
            result.append(BindingUtil.getUnaliasedTypeName(binding, includeParams));
        }
        return result.toString();
    }

    public static String getShortTypeString(Expression expr, Type type) {
        if (expr instanceof ArrayLiteral && type instanceof ArrayType && TypeUtils.Type_NULLTYPE.equals(((ArrayType)type).getElementType()).booleanValue()) {
            return expr.getCanonicalString();
        }
        if (type != null) {
            return BindingUtil.getShortTypeString(type);
        }
        return BindingUtil.getTypeName(expr.resolveMember());
    }

    public static String getShortTypeString(Type binding) {
        return BindingUtil.getShortTypeString(binding, false);
    }

    public static String getShortTypeString(Type binding, boolean includeParams) {
        String s = BindingUtil.getTypeString(binding, includeParams);
        int lastDot = s.lastIndexOf(46);
        if (lastDot == -1) {
            return s;
        }
        return s.substring(lastDot + 1);
    }

    public static String getTypeName(Member member) {
        if (member == null) {
            return "";
        }
        return BindingUtil.getTypeName(member, member.getType());
    }

    public static String getTypeName(Member member, Type type) {
        StringBuilder buf = new StringBuilder();
        if (member instanceof FunctionMember) {
            buf.append(member.getName());
        } else if (type != null) {
            buf.append(BindingUtil.getShortTypeString(type, true));
        }
        if (member != null && member.isNullable()) {
            buf.append('?');
        }
        return buf.toString();
    }

    public static Type getType(Member mbr) {
        if (mbr instanceof Function) {
            return null;
        }
        return mbr.getType();
    }

    public static Type getType(Object obj) {
        if (obj instanceof Member) {
            return BindingUtil.getType((Member)obj);
        }
        if (obj instanceof Type) {
            return (Type)obj;
        }
        return null;
    }

    public static boolean isDynamicallyAccessible(Type type) {
        if (type == null || !(type.getClassifier() instanceof StructPart)) {
            return false;
        }
        StructPart sp = (StructPart)type.getClassifier();
        return sp instanceof Record || !sp.isSubtypeOf((StructPart)TypeUtils.getType((String)"egl:eglx.lang.AnyValue"));
    }

    public static boolean isExplicitlyDynamicallyAccessible(Type type) {
        return TypeUtils.isDynamicType((Type)type);
    }

    public static Member createDynamicAccessMember(Type type, String caseSensitiveName) {
        if (BindingUtil.isDynamicallyAccessible(type)) {
            Field field = IrFactory.INSTANCE.createField();
            field.setName(caseSensitiveName);
            field.setType((Type)BindingUtil.getEAny());
            field.setIsNullable(true);
            return field;
        }
        return null;
    }

    public static Member createExplicitDynamicAccessMember(Type type, String caseSensitiveName) {
        if (BindingUtil.isExplicitlyDynamicallyAccessible(type)) {
            Field field = IrFactory.INSTANCE.createField();
            field.setName(caseSensitiveName);
            field.setType((Type)BindingUtil.getEAny());
            field.setIsNullable(true);
            return field;
        }
        return null;
    }

    public static org.eclipse.edt.mof.egl.Part getEAny() {
        return BindingUtil.findPart(NameUtile.getAsName((String)"eglx.lang"), NameUtile.getAsName((String)"eany"));
    }

    public static boolean isPrivate(org.eclipse.edt.mof.egl.Part part) {
        if (part == null) {
            return false;
        }
        return part.getAccessKind() == AccessKind.ACC_PRIVATE;
    }

    public static boolean isPrivate(Member mbr) {
        if (mbr == null) {
            return false;
        }
        return mbr.getAccessKind() == AccessKind.ACC_PRIVATE;
    }

    public static boolean isAbstract(Type type) {
        return type instanceof EGLClass && ((EGLClass)type).isAbstract() != false;
    }

    public static String getName(Element elem) {
        if (elem instanceof NamedElement) {
            return ((NamedElement)elem).getCaseSensitiveName();
        }
        return "";
    }

    public static boolean isParameterizableType(Type type) {
        return type instanceof ParameterizableType || type != null && type.getClassifier() instanceof ParameterizableType;
    }

    public static void setDefaultSupertype(StructPart part, Stereotype subType, StructPart defaultSuperType) {
        StereotypeType clazz;
        List superTypes = part.getSuperTypes();
        for (StructPart stype : superTypes) {
            if (stype instanceof Interface) continue;
            return;
        }
        if (subType != null && subType.getEClass() instanceof StereotypeType && (clazz = (StereotypeType)subType.getEClass()).getDefaultSuperType() instanceof StructPart) {
            superTypes.add(0, (StructPart)clazz.getDefaultSuperType());
            return;
        }
        if (!part.equals((Type)defaultSuperType).booleanValue()) {
            superTypes.add(0, defaultSuperType);
        }
    }

    public static boolean isZeroLiteral(Expression expr) {
        final boolean[] isZero = new boolean[1];
        expr.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(IntegerLiteral integerLiteral) {
                isZero[0] = Integer.valueOf(integerLiteral.getValue()) == 0;
                return false;
            }
        });
        return isZero[0];
    }

    public static org.eclipse.edt.mof.egl.Part getDeclaringPart(Member m) {
        if (m != null) {
            Object c = m.getContainer();
            while (c != null && !(c instanceof org.eclipse.edt.mof.egl.Part)) {
                c = c instanceof Member ? ((Member)c).getContainer() : null;
            }
            return (org.eclipse.edt.mof.egl.Part)c;
        }
        return null;
    }

    public static org.eclipse.edt.mof.egl.Part getDeclaringPart(Node n) {
        while (n != null && !(n instanceof Part)) {
            n = n.getParent();
        }
        if (n instanceof Part) {
            return (org.eclipse.edt.mof.egl.Part)((Part)n).getName().resolveType();
        }
        return null;
    }

    public static boolean isUnresolvedGenericType(Type type) {
        if (type instanceof ArrayType) {
            Type root = type;
            while (root instanceof ArrayType) {
                root = ((ArrayType)root).getElementType();
            }
            return root instanceof GenericType;
        }
        return type instanceof GenericType;
    }

    public static Type resolveGenericType(Type type, Expression expr) {
        return BindingUtil.resolveGenericType(type, BindingUtil.getTypeForGenericQualifier(expr));
    }

    public static Type resolveGenericType(Type type, Type qualifierType) {
        if (type instanceof ArrayType) {
            if (BindingUtil.isUnresolvedGenericType(type)) {
                return ((ArrayType)type).resolveTypeParameter(qualifierType);
            }
        } else if (type instanceof GenericType) {
            return ((GenericType)type).resolveTypeParameter(qualifierType);
        }
        return type;
    }

    public static Type getTypeForGenericQualifier(Expression expr) {
        class ExitVisitor
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            ExitVisitor() {
            }
        }
        final Type[] type = new Type[1];
        try {
            expr.accept(new AbstractASTVisitor(){

                @Override
                public boolean visit(FunctionInvocation functionInvocation) {
                    functionInvocation.getTarget().accept(this);
                    return false;
                }

                @Override
                public boolean visit(QualifiedName qualifiedName) {
                    type[0] = qualifiedName.getQualifier().resolveType();
                    throw new ExitVisitor();
                }

                @Override
                public boolean visit(BinaryExpression binaryExpression) {
                    Type binType = binaryExpression.resolveType();
                    if (binType != null) {
                        Type type1 = binaryExpression.getFirstExpression().resolveType();
                        type[0] = type1 != null && type1.getClassifier() != null && type1.getClassifier().equals((Type)binType.getClassifier()) != false ? BindingUtil.resolveGenericType(binType, binaryExpression.getFirstExpression()) : BindingUtil.resolveGenericType(binType, binaryExpression.getSecondExpression());
                        throw new ExitVisitor();
                    }
                    return false;
                }

                @Override
                public boolean visit(TernaryExpression ternaryExpression) {
                    Type ternType = ternaryExpression.resolveType();
                    if (ternType != null) {
                        type[0] = BindingUtil.resolveGenericType(ternType, ternaryExpression.getSecondExpr());
                        throw new ExitVisitor();
                    }
                    return false;
                }

                @Override
                public boolean visit(FieldAccess fieldAccess) {
                    type[0] = fieldAccess.getPrimary().resolveType();
                    throw new ExitVisitor();
                }
            });
        }
        catch (ExitVisitor exitVisitor) {}
        if (type[0] != null) {
            return type[0];
        }
        return expr.resolveType();
    }

    public static void setEnvironment(Element e, IEnvironment env) {
        if (e == null) {
            return;
        }
        Annotation a = e.getAnnotation(ENVIRONMENT_ANNOTATION);
        if (a == null) {
            a = BindingUtil.createAnnotation(ENVIRONMENT_ANNOTATION);
            a.setValue((Object)env);
            e.addAnnotation(a);
        }
    }

    public static IEnvironment getEnvironment(Element e) {
        if (e == null) {
            return null;
        }
        Annotation a = e.getAnnotation(ENVIRONMENT_ANNOTATION);
        if (a != null) {
            return (IEnvironment)a.getValue();
        }
        return null;
    }

    public static Annotation getAnnotationWithSimpleName(Element obj, String simpleName) {
        for (Annotation ann : obj.getAnnotations()) {
            if (!ann.getEClass().getName().equalsIgnoreCase(simpleName)) continue;
            return ann;
        }
        return null;
    }

    public static EObject getMofClassProxyFor(Classifier obj) {
        Annotation mofClassAnn = BindingUtil.getAnnotationWithSimpleName((Element)obj, "MofClass");
        if (mofClassAnn != null) {
            String name = (String)mofClassAnn.getValue("name");
            String pkgName = (String)mofClassAnn.getValue("packageName");
            if (name == null || name.length() == 0) {
                name = obj.getCaseSensitiveName();
            }
            if (pkgName == null || pkgName.length() == 0) {
                pkgName = obj.getCaseSensitivePackageName();
            }
            String fullName = pkgName.length() == 0 ? name : String.valueOf(pkgName) + "." + name;
            try {
                return Environment.getCurrentEnv().find(fullName);
            }
            catch (MofObjectNotFoundException mofObjectNotFoundException) {
            }
            catch (DeserializationException deserializationException) {}
        }
        return null;
    }

    public static boolean isSubClassOf(EClass child, EClass parent) {
        if (!child.getSuperTypes().isEmpty()) {
            for (EClass superType : child.getSuperTypes()) {
                if (!superType.getETypeSignature().equals(parent.getETypeSignature())) continue;
                return true;
            }
            for (EClass superType : child.getSuperTypes()) {
                if (!BindingUtil.isSubClassOf(superType, parent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static EType getETypeFromProxy(Element elem) {
        if (elem instanceof EClassProxy) {
            return ((EClassProxy)elem).getProxiedEClass();
        }
        Annotation ann = elem.getAnnotation("egl.lang.reflect.EClassProxy");
        if (ann != null) {
            String key = (String)ann.getValue();
            try {
                EObject eobj = Environment.getCurrentEnv().find(key);
                if (eobj instanceof EType) {
                    return (EType)eobj;
                }
            }
            catch (MofObjectNotFoundException mofObjectNotFoundException) {
            }
            catch (DeserializationException deserializationException) {}
        }
        return null;
    }

    public static String getETypeSignatureFromProxy(Element elem) {
        if (elem instanceof EClassProxy) {
            return ((EClassProxy)elem).getProxiedEClassName();
        }
        Annotation ann = elem.getAnnotation("egl.lang.reflect.EClassProxy");
        if (ann != null) {
            return (String)ann.getValue();
        }
        return null;
    }

    public static boolean isEClassProxy(Element elem) {
        if (elem instanceof EClassProxy) {
            return true;
        }
        Annotation ann = elem.getAnnotation("egl.lang.reflect.EClassProxy");
        return ann != null;
    }

    public static boolean isReferenceCompatible(Type lhsType, Type rhsType) {
        if (lhsType == null || rhsType == null) {
            return true;
        }
        if (lhsType instanceof ArrayType && rhsType instanceof ArrayType) {
            ArrayType array1 = (ArrayType)lhsType;
            ArrayType array2 = (ArrayType)rhsType;
            if (array1.elementsNullable() != array2.elementsNullable()) {
                return false;
            }
            Type elem1 = array1.getElementType();
            Type elem2 = array2.getElementType();
            while (elem1 instanceof ArrayType && elem2 instanceof ArrayType) {
                if (((ArrayType)elem1).elementsNullable() != ((ArrayType)elem2).elementsNullable()) {
                    return false;
                }
                elem1 = ((ArrayType)elem1).getElementType();
                elem2 = ((ArrayType)elem2).getElementType();
            }
            return elem1.equals(elem2);
        }
        boolean isReferenceType = TypeUtils.isReferenceType((Type)lhsType);
        if (isReferenceType != TypeUtils.isReferenceType((Type)rhsType)) {
            return false;
        }
        if (!isReferenceType) {
            if (lhsType.equals(rhsType).booleanValue()) {
                return true;
            }
            return rhsType.getClassifier() instanceof EGLClass && lhsType.getClassifier() instanceof StructPart && ((EGLClass)rhsType.getClassifier()).isSubtypeOf((StructPart)lhsType.getClassifier());
        }
        return TypeUtils.areCompatible((Classifier)lhsType.getClassifier(), (NamedElement)rhsType.getClassifier());
    }

    public static boolean isMoveCompatible(Type targetType, Member targetMember, Type sourceType, Expression source) {
        if (source instanceof ArrayLiteral) {
            Type elementType = targetType;
            if (targetType instanceof ArrayType) {
                elementType = ((ArrayType)targetType).getElementType();
            }
            for (Expression e : ((ArrayLiteral)source).getExpressions()) {
                Type exprType = BindingUtil.resolveGenericType(e.resolveType(), e);
                if (targetType instanceof ArrayType && TypeUtils.Type_NULLTYPE.equals(exprType).booleanValue() && ((ArrayType)targetType).elementsNullable() || IRUtils.isMoveCompatible((Type)elementType, (Member)targetMember, (Type)exprType, (Member)e.resolveMember())) continue;
                return false;
            }
            return true;
        }
        return IRUtils.isMoveCompatible((Type)targetType, (Member)targetMember, (Type)sourceType, (Member)source.resolveMember());
    }

    public static class DelegateSignature
    implements IFunctionSignature {
        private Delegate delegateBinding;

        public DelegateSignature(Delegate delegateBinding) {
            this.delegateBinding = delegateBinding;
        }

        @Override
        public Type getReturnType() {
            return this.delegateBinding.getReturnType();
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return this.delegateBinding.getParameters();
        }

        @Override
        public boolean isReturnNullable() {
            return this.delegateBinding.isNullable();
        }
    }

    public static class FunctionSignature
    implements IFunctionSignature {
        private Function functionBinding;

        public FunctionSignature(Function functionBinding) {
            this.functionBinding = functionBinding;
        }

        @Override
        public Type getReturnType() {
            return this.functionBinding.getReturnType();
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return this.functionBinding.getParameters();
        }

        @Override
        public boolean isReturnNullable() {
            return this.functionBinding.isNullable();
        }
    }

    public static interface IFunctionSignature {
        public Type getReturnType();

        public boolean isReturnNullable();

        public List<FunctionParameter> getParameters();
    }
}

