/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import java.util.ArrayList;

public class SimpleLineTracker {
    String fileContents;
    int[] lineOffsets;

    public SimpleLineTracker(String fileContents) {
        this.fileContents = fileContents;
    }

    public int[] getLineOffsets() {
        if (this.lineOffsets != null) {
            return this.lineOffsets;
        }
        if (this.fileContents == null) {
            this.lineOffsets = new int[0];
            return this.lineOffsets;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(0));
        int length = this.fileContents.length();
        int i = 0;
        while (i < length) {
            char myChar = this.fileContents.charAt(i);
            if (myChar == '\n') {
                list.add(new Integer(i + 1));
            }
            if (myChar == '\r' && i + 1 < length) {
                if (this.fileContents.charAt(i + 1) == '\n') {
                    list.add(new Integer(i + 2));
                    ++i;
                } else {
                    list.add(new Integer(i + 1));
                }
            }
            ++i;
        }
        int[] lines = new int[list.size() + 1];
        lines[0] = -1;
        int index = 1;
        for (Integer x : list) {
            lines[index] = x;
            ++index;
        }
        this.lineOffsets = lines;
        return this.lineOffsets;
    }

    private int getContentsLength() {
        if (this.fileContents == null) {
            return 0;
        }
        return this.fileContents.length();
    }

    public int[] getOffsetsForLine(int line) {
        if (line == 0) {
            return new int[2];
        }
        int[] lines = this.getLineOffsets();
        if (line >= this.getLineOffsets().length) {
            if (lines.length == 0) {
                int[] nArray = new int[2];
                nArray[1] = this.getContentsLength();
                return nArray;
            }
            return new int[]{lines[lines.length - 1], this.getContentsLength()};
        }
        int start = lines[line];
        int end = line == lines.length - 1 ? this.getContentsLength() : lines[line + 1];
        return new int[]{start, end};
    }
}

