/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.type;

import com.sun.mirror.type.ArrayType;
import com.sun.mirror.util.TypeVisitor;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class ArrayTypeImpl
implements ArrayType,
EclipseMirrorType {
    private final ITypeBinding _arrayBinding;
    private final BaseProcessorEnv _env;

    public ArrayTypeImpl(ITypeBinding binding, BaseProcessorEnv env) {
        this._arrayBinding = binding;
        this._env = env;
        assert (this._arrayBinding != null && this._arrayBinding.isArray());
        assert (env != null) : "missing environment";
    }

    public void accept(TypeVisitor visitor) {
        visitor.visitArrayType(this);
    }

    public EclipseMirrorType getComponentType() {
        ITypeBinding result;
        ITypeBinding elementType = this._arrayBinding.getElementType();
        int dimension = this._arrayBinding.getDimensions();
        if (dimension == 0) {
            return null;
        }
        if (dimension == 1) {
            result = elementType;
        } else {
            String componentKey = BindingKey.createArrayTypeBindingKey((String)elementType.getKey(), (int)(dimension - 1));
            result = this._env.getTypeBindingFromKey(componentKey);
            if (result == null) {
                throw new IllegalStateException("unknown component type for " + this._arrayBinding);
            }
        }
        EclipseMirrorType mirror = Factory.createTypeMirror(result, this._env);
        if (mirror == null) {
            return (EclipseMirrorType)((Object)Factory.createErrorClassType(result));
        }
        return mirror;
    }

    public String toString() {
        ITypeBinding elementType = this._arrayBinding.getElementType();
        StringBuilder buffer = new StringBuilder();
        String name = elementType.getQualifiedName();
        buffer.append(name);
        int i = 0;
        int dim = this._arrayBinding.getDimensions();
        while (i < dim) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayTypeImpl) {
            return this._arrayBinding == ((ArrayTypeImpl)obj)._arrayBinding;
        }
        return false;
    }

    public ITypeBinding getTypeBinding() {
        return this._arrayBinding;
    }

    public int hashCode() {
        return this._arrayBinding.hashCode();
    }

    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_ARRAY;
    }

    public BaseProcessorEnv getEnvironment() {
        return this._env;
    }

    public boolean isAssignmentCompatible(EclipseMirrorType left) {
        return this.isSubTypeCompatible(left);
    }

    public boolean isSubTypeCompatible(EclipseMirrorType type) {
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_CLASS) {
            return "java.lang.Object".equals(type.getTypeBinding().getQualifiedName());
        }
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_INTERFACE) {
            return "java.lang.Cloneable".equals(type.getTypeBinding().getQualifiedName()) || "java.io.Serializable".equals(type.getTypeBinding().getQualifiedName());
        }
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_ARRAY) {
            EclipseMirrorType element1 = this.getComponentType();
            EclipseMirrorType element2 = ((ArrayTypeImpl)type).getComponentType();
            return element1.isSubTypeCompatible(element2);
        }
        return false;
    }
}

