/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.ext;

import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.BaseCompilerExtension;
import org.eclipse.edt.compiler.SystemLibraryUtil;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlActionStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.SQLActionStatementGenerator;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.SQLActionStatementValidator;

public class SQLExtension
extends BaseCompilerExtension {
    public String[] getSystemEnvironmentPaths() {
        return new String[]{SystemLibraryUtil.getSystemLibraryPath(SqlActionStatement.class, (String)"egllib")};
    }

    public Class[] getExtendedTypes() {
        return new Class[]{AddStatement.class, CloseStatement.class, DeleteStatement.class, ExecuteStatement.class, ForEachStatement.class, GetByKeyStatement.class, GetByPositionStatement.class, OpenStatement.class, PrepareStatement.class, ReplaceStatement.class};
    }

    public ElementGenerator getElementGeneratorFor(Node node) {
        if (this.shouldExtend(node)) {
            return new SQLActionStatementGenerator();
        }
        return null;
    }

    public ASTValidator getValidatorFor(Node node) {
        if (this.shouldExtend(node)) {
            return new SQLActionStatementValidator();
        }
        return null;
    }

    private boolean shouldExtend(Node node) {
        final boolean[] result = new boolean[1];
        node.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(FromOrToExpressionClause clause) {
                if (!result[0]) {
                    result[0] = Utils.isSQLDataSource(SQLExtension.this.exprToType(clause.getExpression())) || Utils.isSQLResultSet(SQLExtension.this.exprToType(clause.getExpression()));
                }
                return false;
            }

            public boolean visit(WithExpressionClause clause) {
                if (!result[0]) {
                    result[0] = Utils.isSQLStatement(SQLExtension.this.exprToType(clause.getExpression()));
                }
                return false;
            }

            public boolean visit(CloseStatement stmt) {
                if (!result[0]) {
                    result[0] = Utils.isSQLDataSource(SQLExtension.this.exprToType(stmt.getExpr())) || Utils.isSQLResultSet(SQLExtension.this.exprToType(stmt.getExpr()));
                }
                return false;
            }

            public void endVisit(OpenStatement stmt) {
                if (!result[0]) {
                    result[0] = Utils.isSQLResultSet(SQLExtension.this.exprToType(stmt.getResultSet()));
                }
            }
        });
        return result[0];
    }

    private Type exprToType(Expression expr) {
        if (expr != null) {
            return expr.resolveType();
        }
        return null;
    }
}

