/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class AddStatementValidator
extends AbstractSqlStatementValidator {
    AddStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    FromOrToExpressionClause to;
    ForExpressionClause forExpression;

    public AddStatementValidator(AddStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFor();
    }

    private void validateTarget() {
        int[] offsets;
        Expression expr;
        Type type;
        Object o;
        List exprs = this.statement.getTargets();
        boolean isEntity = false;
        if (exprs.size() == 1 && (o = exprs.get(0)) instanceof Expression && this.isEntity(type = (expr = (Expression)o).resolveType())) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            isEntity = true;
        }
        if (!isEntity && !this.mapsToColumns(exprs)) {
            offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8506, true, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (!isEntity && this.forExpression == null && !this.mapsToSingleTable(exprs)) {
            offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8518, true, new String[]{"for"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        Type targetType = this.getTargetType();
        if (targetType != null && !this.isSingleTable(targetType)) {
            int[] offsets2 = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets2[0], offsets2[1], 8515, true, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            Type type;
            if (this.to != null && (type = this.to.getExpression().resolveType()) != null && Utils.isSQLResultSet(type)) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8510, 2, new String[]{"eglx.persistence.sql.SQLResultSet"}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            type = this.forExpression.getExpression().resolveType();
            if (type != null) {
                if (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression())) {
                    this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, 2, new String[]{this.forExpression.getExpression().getCanonicalString()}, SQLResourceKeys.getResourceBundleForKeys());
                    return;
                }
                Type targetType = this.getTargetType();
                if (targetType != null && !targetType.equals(type).booleanValue()) {
                    this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8507, 2, new String[]{this.forExpression.getExpression().getCanonicalString(), type.getTypeSignature(), targetType.getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
                    return;
                }
            }
        }
    }

    private Type getTargetType() {
        Expression e;
        Type type = null;
        List targets = this.statement.getTargets();
        int size = targets.size();
        if (!(size <= 0 || (type = (e = (Expression)targets.get(0)).resolveType()) == null || size == 1 && this.isEntity(type))) {
            type = null;
            if (this.mapsToSingleTable(targets)) {
                type = this.getContainingType(e.resolveMember());
            }
        }
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        return type;
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(FromOrToExpressionClause clause) {
                if (AddStatementValidator.this.to == null) {
                    AddStatementValidator.this.to = clause;
                } else {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"add".toUpperCase(), "to".toUpperCase()});
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                if (AddStatementValidator.this.forExpression == null) {
                    AddStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"add".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }
        });
    }
}

