/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class ForEachStatementValidator
extends AbstractSqlStatementValidator {
    ForEachStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    FromOrToExpressionClause from;

    public ForEachStatementValidator(ForEachStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFrom();
    }

    private void validateTarget() {
        Expression expr;
        Type type;
        Object o;
        List exprs = this.statement.getTargets();
        boolean isEntity = false;
        if (exprs.size() == 1 && (o = exprs.get(0)) instanceof Expression && this.isEntity(type = (expr = (Expression)o).resolveType())) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            isEntity = true;
        }
        if (!isEntity && !this.mapsToColumns(exprs)) {
            int[] offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8506, true, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateFrom() {
        Type type;
        if (this.from != null && (type = this.from.getExpression().resolveType()) != null && !Utils.isSQLResultSet(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, 2, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLResultSet"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(ForEachStatement forEachStatement) {
                this.visit(forEachStatement.getTargets());
                forEachStatement.getResultSet().accept((IASTVisitor)this);
                return false;
            }

            private void visit(List<Node> list) {
                for (Node node : list) {
                    node.accept((IASTVisitor)this);
                }
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (ForEachStatementValidator.this.from == null) {
                    ForEachStatementValidator.this.from = clause;
                } else {
                    ForEachStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"forEach".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }
        });
    }
}

