/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class PrepareStatementValidator
extends AbstractSqlStatementValidator {
    PrepareStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    FromOrToExpressionClause from;

    public PrepareStatementValidator(PrepareStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFrom();
        this.validateWith();
    }

    private void validateTarget() {
        Type targetType = this.statement.getSqlStmt().resolveType();
        if (targetType != null && !Utils.isSQLStatement(targetType)) {
            this.problemRequestor.acceptProblem((Node)this.statement.getSqlStmt(), 8500, 2, new String[]{this.statement.getSqlStmt().getCanonicalString(), "eglx.persistence.sql.SQLStatement"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateFrom() {
        Type type;
        if (this.from != null && (type = this.from.getExpression().resolveType()) != null && !Utils.isSQLDataSource(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, 2, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateWith() {
        if (this.withExpression != null) {
            Type type = this.withExpression.getExpression().resolveType();
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getParameterizableType();
            }
            if (type != null && !type.equals(TypeUtils.Type_STRING).booleanValue()) {
                this.problemRequestor.acceptProblem((Node)this.withExpression.getExpression(), 8500, 2, new String[]{this.withExpression.getExpression().getCanonicalString(), "string"}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (PrepareStatementValidator.this.withInline == null && PrepareStatementValidator.this.withExpression == null) {
                    PrepareStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"prepare".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (PrepareStatementValidator.this.withInline == null && PrepareStatementValidator.this.withExpression == null) {
                    PrepareStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"prepare".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (PrepareStatementValidator.this.from == null) {
                    PrepareStatementValidator.this.from = clause;
                } else {
                    PrepareStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"prepare".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }
        });
    }
}

