/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ArabicOption;
import com.ibm.as400.access.ArabicOptionSet;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.Serializable;

public class BidiConversionProperties
implements Serializable {
    static final long serialVersionUID = 4L;
    private int bidiStringType_ = 0;
    private boolean removeMarksOnImplicitToVisual_ = false;
    private boolean impToImp_ = true;
    private boolean roundTrip_;
    private boolean winCompatible_;
    private boolean insertMarkers_;
    private boolean removeMarkers_;
    private int options_;
    private boolean wordBreak_;
    private boolean destinationRequired_ = true;
    private boolean srcToDstMapRequired_;
    private boolean dstToSrcMapRequired_;
    private boolean propertyMapRequired_;
    private boolean continuation_;
    private int numeralShaping_ = 0;
    private int inpCount_;
    private int outCount_;
    private int[] srcToDstMap_;
    private int[] dstToSrcMap_;
    private byte[] propertyMap_;
    private boolean expandLamAlef = false;
    public static final int NUMERALS_DEFAULT = 0;
    public static final int NUMERALS_NOMINAL = 1;
    public static final int NUMERALS_NATIONAL = 2;
    public static final int NUMERALS_CONTEXTUAL = 3;
    public static final int NUMERALS_ANY = 4;

    public BidiConversionProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BidiConversionProperties.");
        }
    }

    BidiConversionProperties(int n) {
        this.setBidiStringType(n);
    }

    BidiConversionProperties(int n, BidiTransform bidiTransform, boolean bl) {
        this.setBidiStringType(n);
        this.impToImp_ = bidiTransform.impToImp;
        this.roundTrip_ = bidiTransform.roundTrip;
        this.winCompatible_ = bidiTransform.winCompatible;
        this.insertMarkers_ = bidiTransform.insertMarkers;
        this.removeMarkers_ = bidiTransform.removeMarkers;
        if (bidiTransform.options != null) {
            this.options_ = bidiTransform.options.value;
        }
        this.wordBreak_ = bidiTransform.wordBreak;
        this.destinationRequired_ = bidiTransform.destinationRequired;
        this.srcToDstMapRequired_ = bidiTransform.srcToDstMapRequired;
        this.dstToSrcMapRequired_ = bidiTransform.dstToSrcMapRequired;
        this.propertyMapRequired_ = bidiTransform.propertyMapRequired;
        this.continuation_ = bidiTransform.continuation;
        this.removeMarksOnImplicitToVisual_ = bl;
        if (bl) {
            this.removeMarkers_ = false;
        }
        this.dstToSrcMap_ = bidiTransform.dstToSrcMap;
        this.srcToDstMap_ = bidiTransform.srcToDstMap;
        this.propertyMap_ = bidiTransform.propertyMap;
        this.inpCount_ = bidiTransform.inpCount;
        this.outCount_ = bidiTransform.outCount;
        this.getNumeralShapingFromTransform(bidiTransform);
        this.expandLamAlef = bidiTransform.options != null ? bidiTransform.options.getLamAlefMode() == ArabicOption.LAMALEF_RESIZE_BUFFER : false;
    }

    public void setBidiStringType(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi string type:", n);
        }
        if (n != -1 && n != 0 && (n < 4 || n > 11)) {
            Trace.log(2, "Value of parameter 'bidiStringType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("bidiStringType (" + n + ")", 2);
        }
        this.bidiStringType_ = n;
    }

    public int getBidiStringType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting bidi string type:", this.bidiStringType_);
        }
        return this.bidiStringType_;
    }

    public void setBidiRemoveMarksOnImplicitToVisual(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi remove the directional marks only when transforming from logical to visual property:", bl);
        }
        this.removeMarksOnImplicitToVisual_ = bl;
    }

    public boolean isBidiRemoveMarksOnImplicitToVisual() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if remove the directional marks only when transforming from logical to visual property is set:", this.removeMarksOnImplicitToVisual_);
        }
        return this.removeMarksOnImplicitToVisual_;
    }

    void copyOptionsTo(BidiTransform bidiTransform) {
        bidiTransform.impToImp = this.impToImp_;
        bidiTransform.roundTrip = this.roundTrip_;
        bidiTransform.winCompatible = this.winCompatible_;
        bidiTransform.insertMarkers = this.insertMarkers_;
        bidiTransform.removeMarkers = this.removeMarkers_;
        if (this.options_ == 0) {
            bidiTransform.options = null;
        } else {
            bidiTransform.options.value = this.options_;
        }
        ArabicOptionSet arabicOptionSet = new ArabicOptionSet();
        int n = arabicOptionSet.value = bidiTransform.options == null ? 0 : bidiTransform.options.value;
        if (this.expandLamAlef) {
            arabicOptionSet.setOneOption(ArabicOption.LAMALEF_RESIZE_BUFFER);
            bidiTransform.options = new ArabicOptionSet(arabicOptionSet);
        }
        bidiTransform.wordBreak = this.wordBreak_;
        bidiTransform.destinationRequired = this.destinationRequired_;
        bidiTransform.srcToDstMapRequired = this.srcToDstMapRequired_;
        bidiTransform.dstToSrcMapRequired = this.dstToSrcMapRequired_;
        bidiTransform.propertyMapRequired = this.propertyMapRequired_;
        bidiTransform.continuation = this.continuation_;
        this.setNumeralShapingOnTransform(bidiTransform);
    }

    void setNumeralShapingOnTransform(BidiTransform bidiTransform) {
        switch (this.numeralShaping_) {
            case 1: {
                bidiTransform.flags.setOneFlag(BidiFlag.NUMERALS_NOMINAL);
                break;
            }
            case 2: {
                bidiTransform.flags.setOneFlag(BidiFlag.NUMERALS_NATIONAL);
                break;
            }
            case 3: {
                bidiTransform.flags.setOneFlag(BidiFlag.NUMERALS_CONTEXTUAL);
                break;
            }
            case 4: {
                bidiTransform.flags.setOneFlag(BidiFlag.NUMERALS_ANY);
                break;
            }
        }
    }

    void getNumeralShapingFromTransform(BidiTransform bidiTransform) {
        BidiFlag bidiFlag = bidiTransform.flags.getNumerals();
        if (bidiFlag == BidiFlag.NUMERALS_NOMINAL) {
            this.numeralShaping_ = 1;
        } else if (bidiFlag == BidiFlag.NUMERALS_NATIONAL) {
            this.numeralShaping_ = 2;
        } else if (bidiFlag == BidiFlag.NUMERALS_CONTEXTUAL) {
            this.numeralShaping_ = 3;
        } else if (bidiFlag == BidiFlag.NUMERALS_ANY) {
            this.numeralShaping_ = 4;
        }
    }

    public void setBidiImplicitReordering(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi implicit LTR-RTL reordering:", bl);
        }
        this.impToImp_ = bl;
    }

    public boolean isBidiImplicitReordering() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi implicit LTR-RTL reordering:", this.impToImp_);
        }
        return this.impToImp_;
    }

    public void setBidiNumericOrderingRoundTrip(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi numeric ordering round trip:", bl);
        }
        this.roundTrip_ = bl;
    }

    public boolean isBidiNumericOrderingRoundTrip() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi numeric ordering round trip:", this.roundTrip_);
        }
        return this.roundTrip_;
    }

    public void setBidiWindowCompatibility(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi window compatibility:", bl);
        }
        this.winCompatible_ = bl;
    }

    public boolean isBidiWindowCompatibility() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi window compatibility:", this.winCompatible_);
        }
        return this.winCompatible_;
    }

    public void setBidiInsertDirectionalMarks(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi insert directional marks:", bl);
        }
        this.insertMarkers_ = bl;
    }

    public boolean isBidiInsertDirectionalMarks() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi insert directional marks:", this.insertMarkers_);
        }
        return this.insertMarkers_;
    }

    public void setBidiRemoveDirectionalMarks(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi remove directional marks:", bl);
        }
        this.removeMarkers_ = bl;
    }

    public boolean isBidiRemoveDirectionalMarks() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi remove directional marks:", this.removeMarkers_);
        }
        return this.removeMarkers_;
    }

    public void setBidiWordBreak(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi word break:", bl);
        }
        this.wordBreak_ = bl;
    }

    public boolean isBidiWordBreak() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi consider white space to always follow base orientation:", this.wordBreak_);
        }
        return this.wordBreak_;
    }

    public void setBidiNumeralShaping(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting numeral shaping:", n);
        }
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("numeralShaping (" + n + ")", 2);
        }
        this.numeralShaping_ = n;
    }

    public int getBidiNumeralShaping() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking numeral shaping:", this.numeralShaping_);
        }
        return this.numeralShaping_;
    }

    public void setBidiDestinationRequired(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi destination required:", bl);
        }
        this.destinationRequired_ = bl;
    }

    public boolean isBidiDestinationRequired() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi destination required:", this.destinationRequired_);
        }
        return this.destinationRequired_;
    }

    public void setBidiCreateSourceToDestinationMapping(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create a source to destination mapping property:", bl);
        }
        this.srcToDstMapRequired_ = bl;
    }

    public boolean isBidiCreateSourceToDestinationMapping() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if create a source to destination mapping property is set:", this.srcToDstMapRequired_);
        }
        return this.srcToDstMapRequired_;
    }

    public void setBidiCreateDestinationToSourceMapping(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create a destination to source mapping property:", bl);
        }
        this.dstToSrcMapRequired_ = bl;
    }

    public boolean isBidiCreateDestinationToSourceMapping() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if create a destination to source mapping property is set:", this.dstToSrcMapRequired_);
        }
        return this.dstToSrcMapRequired_;
    }

    public void setBidiCreatePropertyMap(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting bidi create property map property:", bl);
        }
        this.propertyMapRequired_ = bl;
    }

    public boolean isBidiCreatePropertyMap() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if bidi create property map property is set:", this.propertyMapRequired_);
        }
        return this.propertyMapRequired_;
    }

    public int getInputCount() {
        return this.inpCount_;
    }

    public int getOutputCount() {
        return this.outCount_;
    }

    public int[] getSourceToDestinationMap() {
        return this.srcToDstMap_;
    }

    public int[] getDestinationToSourceMap() {
        return this.dstToSrcMap_;
    }

    public byte[] getPropertyMap() {
        return this.propertyMap_;
    }

    public boolean isBidiExpandLamAlef() {
        return this.expandLamAlef;
    }

    public void setBidiExpandLamAlef(boolean bl) {
        this.expandLamAlef = bl;
    }
}

