/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyPackageInfo;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDPackageManager {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String SUFFIX_INVARIANT_ = "9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA";
    private boolean cache_;
    private DBReplyPackageInfo cachedPackage_;
    private ConvTable cachedPackageConverter_;
    private int cachedStatementCount_;
    private boolean clear_;
    private AS400JDBCConnection connection_;
    private boolean created_;
    private boolean enabled_;
    private String error_;
    private int id_;
    private String libraryName_;
    private String name_;
    private int threshold_;

    JDPackageManager(AS400JDBCConnection aS400JDBCConnection, int n, JDProperties jDProperties, int n2) throws SQLException {
        this.enabled_ = jDProperties.getBoolean(7);
        if (this.enabled_) {
            this.cache_ = jDProperties.getBoolean(12);
            this.clear_ = jDProperties.getBoolean(13);
            this.connection_ = aS400JDBCConnection;
            this.created_ = false;
            this.error_ = jDProperties.getString(14);
            this.id_ = n;
            this.threshold_ = this.clear_ ? 512 : 0;
            String string = jDProperties.getString(15);
            this.libraryName_ = string.length() > 0 ? string.toUpperCase() : "QGPL";
            String string2 = jDProperties.getString(10);
            if (string2.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(10);
                String string3 = string2.length() >= 6 ? string2.substring(0, 6) : string2;
                stringBuffer.append(string3.toUpperCase().replace(' ', '_'));
                stringBuffer.append(this.getSuffix(jDProperties, n2));
                this.name_ = stringBuffer.toString();
            } else {
                this.enabled_ = false;
                this.postError("01H11");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache() throws SQLException {
        if (this.enabled_) {
            try {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Caching package [" + this.name_ + "]");
                }
                DBSQLRequestDS dBSQLRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6165, this.id_, -2146435072, 0);
                    dBSQLRequestDS.setPackageName(this.name_, this.connection_.converter_);
                    dBSQLRequestDS.setLibraryName(this.libraryName_, this.connection_.converter_);
                    dBSQLRequestDS.setReturnSize(0);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    if (n != 0) {
                        this.cache_ = false;
                        this.postError("01H12");
                    } else {
                        this.cachedPackage_ = dBReplyRequestedDS.getPackageInfo();
                        this.cachedPackageConverter_ = this.connection_.getConverter(this.cachedPackage_.getCCSID());
                        this.cachedStatementCount_ = this.cachedPackage_.getStatementCount();
                    }
                    Object var5_5 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                    throw throwable;
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create() throws SQLException {
        if (this.enabled_) {
            try {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Creating package [" + this.name_ + "]");
                }
                DBSQLRequestDS dBSQLRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6159, this.id_, Integer.MIN_VALUE, 0);
                    dBSQLRequestDS.setPackageName(this.name_, this.connection_.converter_);
                    dBSQLRequestDS.setLibraryName(this.libraryName_, this.connection_.converter_);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n == 1 && n2 == -601) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this.connection_, "Package [" + this.name_ + "] already exists");
                        }
                        if (this.cache_) {
                            this.cache();
                        }
                    } else if (n2 == -999999) {
                        this.enabled_ = false;
                        this.postError("01H11");
                    } else if (n != 0) {
                        this.enabled_ = false;
                        this.postError(this.connection_, this.id_, n, n2);
                    }
                    Object var6_6 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                    throw throwable;
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
        }
        this.created_ = true;
    }

    DBDataFormat getCachedDataFormat(int n) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getDataFormat(n);
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        return null;
    }

    DBDataFormat getCachedParameterMarkerFormat(int n) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getParameterMarkerFormat(n);
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        return null;
    }

    int getCachedStatementIndex(JDSQLStatement jDSQLStatement) throws SQLException {
        if (!this.isCached()) {
            return -1;
        }
        String string = jDSQLStatement.toString();
        int n = string.length();
        if (this.connection_.getVRM() >= JDUtilities.vrm510) {
            n *= 2;
        }
        for (int i = 0; i < this.cachedStatementCount_; ++i) {
            try {
                if (n != this.cachedPackage_.getStatementTextLength(i) || !string.equals(this.cachedPackage_.getStatementText(i, this.cachedPackageConverter_))) continue;
                return i;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
        }
        return -1;
    }

    String getCachedStatementName(int n) throws SQLException {
        try {
            if (this.isCached()) {
                return this.cachedPackage_.getStatementName(n, null);
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        return null;
    }

    String getLibraryName() {
        return this.libraryName_;
    }

    String getName() {
        return this.name_;
    }

    private String getSuffix(JDProperties jDProperties, int n) {
        StringBuffer stringBuffer = new StringBuffer(4);
        int n2 = jDProperties.getIndex(55);
        stringBuffer.append(SUFFIX_INVARIANT_.charAt(n2));
        int n3 = jDProperties.getIndex(4);
        if (n == 4) {
            switch (n3) {
                case 0: 
                case 1: 
                case 2: {
                    n = n3;
                    n3 = 6;
                    break;
                }
                case 3: 
                case 4: {
                    n = n3 - 2;
                    n3 = 7;
                }
            }
        }
        n2 = n << 3 | jDProperties.getIndex(3);
        stringBuffer.append(SUFFIX_INVARIANT_.charAt(n2));
        n2 = jDProperties.getIndex(5) << 4 | jDProperties.getIndex(9) << 3 | n3;
        stringBuffer.append(SUFFIX_INVARIANT_.charAt(n2));
        n2 = jDProperties.getIndex(24) << 2 | jDProperties.getIndex(25);
        stringBuffer.append(SUFFIX_INVARIANT_.charAt(n2));
        return stringBuffer.toString();
    }

    int getThreshold() {
        return this.threshold_;
    }

    boolean isCached() {
        return this.cachedPackage_ != null;
    }

    boolean isCreated() {
        return this.created_;
    }

    boolean isEnabled() {
        return this.enabled_;
    }

    private void postError(String string) throws SQLException {
        if (this.error_.equalsIgnoreCase("exception")) {
            JDError.throwSQLException(string);
        } else if (this.error_.equalsIgnoreCase("warning")) {
            this.connection_.postWarning(JDError.getSQLWarning(string));
        }
    }

    private void postError(AS400JDBCConnection aS400JDBCConnection, int n, int n2, int n3) throws SQLException {
        if (this.error_.equalsIgnoreCase("exception")) {
            JDError.throwSQLException(aS400JDBCConnection, n, n2, n3);
        } else if (this.error_.equalsIgnoreCase("warning")) {
            this.connection_.postWarning(JDError.getSQLWarning(aS400JDBCConnection, n, n2, n3));
        }
    }
}

