/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MemberDescription {
    private static final SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyMMddHHmmss");
    private static final SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyMMdd");
    private static final String QUSRMBRD_FORMAT_100 = "MBRD0100";
    private static final String QUSRMBRD_FORMAT_200 = "MBRD0200";
    private static final String QUSRMBRD_FORMAT_300 = "MBRD0300";
    public static final int FILE_NAME = 1;
    public static final int LIBRARY_NAME = 2;
    public static final int MEMBER_NAME = 3;
    public static final int FILE_ATTRIBUTE = 4;
    public static final int SOURCE_TYPE = 5;
    public static final int CREATION_DATE_TIME = 6;
    public static final int LAST_SOURCE_CHANGE_DATE = 7;
    public static final int MEMBER_TEXT_DESCRIPTION = 8;
    public static final int SOURCE_FILE = 9;
    public static final int REMOTE_FILE = 10;
    public static final int LOGICAL_FILE = 11;
    public static final int ODP_SHARING = 12;
    public static final int CURRENT_NUMBER_OF_RECORDS = 13;
    public static final int DATA_SPACE_SIZE = 14;
    public static final int ACCESS_PATH_SIZE = 15;
    public static final int NUMBER_OF_BASED_ON_PHYICAL_FILE_MEMBERS = 16;
    public static final int CHANGE_DATE_AND_TIME = 17;
    public static final int SAVE_DATE_AND_TIME = 18;
    public static final int RESTORE_DATE_AND_TIME = 19;
    public static final int EXPIRATION_DATE = 20;
    public static final int NUMBER_OF_DAYS_USED = 21;
    public static final int DATE_LAST_USED = 22;
    public static final int USE_RESET_DATE = 23;
    public static final int DATA_SPACE_SIZE_MULTIPLIER = 24;
    public static final int ACCESS_PATH_SIZE_MULTIPLIER = 25;
    public static final int MEMBER_TEXT_DESCRIPTION_CCSID = 26;
    public static final int NUMBER_OF_DELETED_RECORDS = 27;
    public static final int JOIN_MEMBER = 28;
    public static final int ACCESS_PATH_MAINTENANCE = 29;
    public static final int SQL_FILE_TYPE = 30;
    public static final int ALLOW_READ_OPERATION = 31;
    public static final int ALLOW_WRITE_OPERATION = 32;
    public static final int ALLOW_UPDATE_OPERATION = 33;
    public static final int ALLOW_DELETE_OPERATION = 34;
    public static final int RECORDS_TO_FORCE_A_WRITE = 35;
    public static final int MAXIMUM_PERCENT_DELETED_RECORDS_ALLOWED = 36;
    public static final int INITIAL_NUMBER_OF_RECORDS = 37;
    public static final int INCREMENT_NUMBER_OF_RECORDS = 38;
    public static final int MAXIMUM_NUMBER_OF_INCREMENTS = 39;
    public static final int CURRENT_NUMBER_OF_INCREMENTS = 40;
    public static final int RECORD_CAPACITY = 41;
    public static final int RECORD_FORMAT_SELECTOR_PROGRAM_NAME = 42;
    public static final int RECORD_FORMAT_SELECTOR_LIBRARY_NAME = 43;
    private AS400 system_;
    private QSYSObjectPathName pathName_;
    private HashMap attributes_ = new HashMap();
    private final AS400Bin4 intConverter_ = new AS400Bin4();

    public MemberDescription(AS400 aS400, String string) {
        this(aS400, new QSYSObjectPathName(string));
    }

    public MemberDescription(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (qSYSObjectPathName == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.pathName_ = qSYSObjectPathName;
    }

    public MemberDescription(AS400 aS400, String string, String string2, String string3) {
        this(aS400, new QSYSObjectPathName(string, string2, string3, "MBR"));
    }

    MemberDescription(AS400 aS400, QSYSObjectPathName qSYSObjectPathName, Map map) {
        this(aS400, qSYSObjectPathName);
        this.attributes_.putAll(map);
    }

    private String lookupFormat(int n) {
        String string;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = QUSRMBRD_FORMAT_100;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = QUSRMBRD_FORMAT_200;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = QUSRMBRD_FORMAT_300;
                break;
            }
            default: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unrecognized attribute key:", n);
                }
                string = QUSRMBRD_FORMAT_100;
            }
        }
        return string;
    }

    public Object getValue(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        Integer n2 = new Integer(n);
        Object object = null;
        object = this.attributes_.get(n2);
        if (object == null) {
            object = this.retrieve(n);
            this.attributes_.put(n2, object);
        }
        return object;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(43);
    }

    void setAttribute(int n, Object object) {
        this.attributes_.put(new Integer(n), object);
    }

    private Object retrieve(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String string = this.lookupFormat(n);
        ProgramParameter[] programParameterArray = this.buildProgramParameters(string);
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QUSRMBRD.PGM", programParameterArray);
        if (programCall.run()) {
            this.readMemberInfo(programParameterArray[0].getOutputData(), string);
            return this.attributes_.get(new Integer(n));
        }
        throw new AS400Exception(programCall.getMessageList());
    }

    private ProgramParameter[] buildProgramParameters(String string) throws UnsupportedEncodingException {
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        ProgramParameter[] programParameterArray = new ProgramParameter[7];
        programParameterArray[0] = new ProgramParameter(332);
        programParameterArray[1] = new ProgramParameter(this.intConverter_.toBytes(332));
        programParameterArray[2] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, string));
        programParameterArray[3] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, this.pathName_.toQualifiedObjectName()));
        String string2 = this.pathName_.getMemberName();
        if (string2.length() == 0) {
            string2 = "*FIRST";
            if (Trace.traceOn_) {
                Trace.log(1, "Defaulting to member *FIRST", this.pathName_.getPath());
            }
        }
        programParameterArray[4] = new ProgramParameter(new AS400Text(10).toBytes(string2));
        programParameterArray[5] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, "1"));
        programParameterArray[6] = new ErrorCodeParameter();
        return programParameterArray;
    }

    private static final int offsetOf(int n) {
        switch (n) {
            case 1: {
                return 8;
            }
            case 2: {
                return 18;
            }
            case 3: {
                return 28;
            }
            case 4: {
                return 38;
            }
            case 5: {
                return 48;
            }
            case 6: {
                return 58;
            }
            case 7: {
                return 71;
            }
            case 8: {
                return 84;
            }
            case 9: {
                return 134;
            }
            case 10: {
                return 135;
            }
            case 11: {
                return 136;
            }
            case 12: {
                return 137;
            }
            case 13: {
                return 140;
            }
            case 14: {
                return 148;
            }
            case 15: {
                return 152;
            }
            case 16: {
                return 156;
            }
            case 17: {
                return 160;
            }
            case 18: {
                return 173;
            }
            case 19: {
                return 186;
            }
            case 20: {
                return 199;
            }
            case 21: {
                return 212;
            }
            case 22: {
                return 216;
            }
            case 23: {
                return 223;
            }
            case 24: {
                return 232;
            }
            case 25: {
                return 236;
            }
            case 26: {
                return 240;
            }
            case 27: {
                return 256;
            }
            case 28: {
                return 266;
            }
            case 29: {
                return 267;
            }
            case 30: {
                return 268;
            }
            case 31: {
                return 279;
            }
            case 32: {
                return 280;
            }
            case 33: {
                return 281;
            }
            case 34: {
                return 282;
            }
            case 35: {
                return 284;
            }
            case 36: {
                return 288;
            }
            case 37: {
                return 292;
            }
            case 38: {
                return 296;
            }
            case 39: {
                return 300;
            }
            case 40: {
                return 304;
            }
            case 41: {
                return 308;
            }
            case 42: {
                return 312;
            }
            case 43: {
                return 322;
            }
        }
        Trace.log(2, "Unrecognized attribute key:", n);
        throw new InternalErrorException(6, n);
    }

    private void readMemberInfo(byte[] byArray, String string) throws UnsupportedEncodingException {
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        this.setAttribute(1, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(1), 10).trim());
        this.setAttribute(2, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(2), 10).trim());
        this.setAttribute(4, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(4), 10).trim());
        this.setAttribute(3, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(3), 10).trim());
        this.setAttribute(5, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(5), 10).trim());
        this.setAttribute(8, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(8), 50).trim());
        this.setAttribute(7, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(7), 13)));
        this.setAttribute(6, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(6), 13)));
        this.setAttribute(9, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(9), 1)));
        if (string != QUSRMBRD_FORMAT_100) {
            this.setAttribute(10, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(10), 1)));
            this.setAttribute(11, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(11), 1)));
            this.setAttribute(13, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(13))));
            this.setAttribute(12, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(12), 1)));
            this.setAttribute(14, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(14))));
            this.setAttribute(15, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(15))));
            this.setAttribute(16, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(16))));
            this.setAttribute(17, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(17), 13)));
            this.setAttribute(19, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(19), 13)));
            this.setAttribute(18, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(18), 13)));
            this.setAttribute(20, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(20), 13)));
            this.setAttribute(21, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(21))));
            this.setAttribute(22, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(22), 13)));
            this.setAttribute(23, this.transformDate(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(23), 13)));
            this.setAttribute(24, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(24))));
            this.setAttribute(25, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(25))));
            this.setAttribute(26, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(26))));
            this.setAttribute(27, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(27))));
        }
        if (QUSRMBRD_FORMAT_300.equals(string)) {
            this.setAttribute(28, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(28), 1)));
            this.setAttribute(29, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(29), 1));
            this.setAttribute(30, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(30), 10).trim());
            this.setAttribute(31, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(31), 1)));
            this.setAttribute(32, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(32), 1)));
            this.setAttribute(33, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(33), 1)));
            this.setAttribute(34, this.transformBoolean(charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(34), 1)));
            this.setAttribute(35, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(35))));
            this.setAttribute(36, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(36))));
            this.setAttribute(37, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(37))));
            this.setAttribute(38, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(38))));
            this.setAttribute(39, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(39))));
            this.setAttribute(40, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(40))));
            this.setAttribute(41, new Integer(this.intConverter_.toInt(byArray, MemberDescription.offsetOf(41))));
            this.setAttribute(42, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(42), 10).trim());
            this.setAttribute(43, charConverter.byteArrayToString(byArray, MemberDescription.offsetOf(43), 10).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date transformDate(String string) {
        Date date;
        block12: {
            date = null;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    if (string.length() == 13) {
                        SimpleDateFormat simpleDateFormat = dateTimeFormat_;
                        synchronized (simpleDateFormat) {
                            date = dateTimeFormat_.parse(string.substring(1));
                            break block12;
                        }
                    }
                    if (string.length() == 7) {
                        SimpleDateFormat simpleDateFormat = dateFormat_;
                        synchronized (simpleDateFormat) {
                            date = dateFormat_.parse(string.substring(1));
                            break block12;
                        }
                    }
                    if (Trace.traceOn_) {
                        Trace.log(4, "Date string has unrecognized format:", string);
                    }
                }
                catch (ParseException parseException) {
                    if (!Trace.traceOn_) break block12;
                    Trace.log(2, "Ignored error while parsing date string: " + string, (Throwable)parseException);
                }
            }
        }
        return date;
    }

    private Boolean transformBoolean(String string) {
        if (string.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getPath() {
        return this.pathName_.getPath();
    }
}

