/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class SystemStatus
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    private AS400 system_;
    byte[][] receiverVariables_ = new byte[4][];
    private Vector poolsVector_;
    private transient boolean connected_ = false;
    private transient boolean caching_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private transient AS400Timestamp timestampConverter_;
    private static final int FORMAT_DTS = 1;

    public SystemStatus() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemStatus object.");
        }
    }

    public SystemStatus(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemStatus object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public int getActiveJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 100);
    }

    public int getActiveThreadsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 104);
    }

    public int getBatchJobsEndedWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 76);
    }

    public int getBatchJobsEnding() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 56);
    }

    public int getBatchJobsHeldOnJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 64);
    }

    public int getBatchJobsHeldWhileRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 52);
    }

    public int getBatchJobsOnAHeldJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 68);
    }

    public int getBatchJobsOnUnassignedJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 72);
    }

    public int getBatchJobsRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 48);
    }

    public int getBatchJobsWaitingForMessage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 44);
    }

    public int getBatchJobsWaitingToRunOrAlreadyScheduled() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 60);
    }

    public float getCurrentProcessingCapacity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 88) / 100.0f;
    }

    public int getCurrentUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 60);
    }

    public Date getDateAndTimeStatusGathered() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(0);
        byte[] byArray = new byte[8];
        System.arraycopy(this.receiverVariables_[0], 8, byArray, 0, 8);
        AS400Timestamp aS400Timestamp = this.getTimestampConverter(1);
        return aS400Timestamp.toDate(aS400Timestamp.toTimestamp(byArray), TimeZone.getDefault());
    }

    public int getElapsedTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (!this.caching_) {
            this.refreshCache();
        }
        if (this.receiverVariables_[2] == null) {
            if (this.receiverVariables_[3] == null) {
                this.loadInformation(2);
                n = 2;
            } else {
                n = 3;
            }
        } else {
            n = 2;
        }
        int n2 = (this.receiverVariables_[n][24] & 0xF) * 10 + (this.receiverVariables_[n][25] & 0xF);
        int n3 = (this.receiverVariables_[n][26] & 0xF) * 10 + (this.receiverVariables_[n][27] & 0xF);
        int n4 = (this.receiverVariables_[n][28] & 0xF) * 10 + (this.receiverVariables_[n][29] & 0xF);
        return n2 * 3600 + n3 * 60 + n4;
    }

    public int getJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 36);
    }

    public long getMainStorageSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        if (this.system_.getVRM() < 328704) {
            return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 72);
        }
        return BinaryConverter.byteArrayToLong(this.receiverVariables_[2], 140);
    }

    public long getMaximumJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 108);
    }

    public int getMaximumUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 64);
    }

    public int getNumberOfPartitions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 76);
    }

    public int getNumberOfProcessors() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 96);
    }

    public int getPartitionIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 80);
    }

    public float getPercentCurrentInteractivePerformance() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 128);
    }

    public float getPercentDBCapability() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int n = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 68);
        return n == -1 ? -1.0f : (float)n / 10.0f;
    }

    public float getPercentPermanentAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 40) / 1000.0f;
    }

    public float getPercentPermanent256MBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 120) / 1000.0f;
    }

    public float getPercentPermanent4GBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 124) / 1000.0f;
    }

    public float getPercentProcessingUnitUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 32) / 10.0f;
    }

    public float getPercentSharedProcessorPoolUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int n = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 136);
        return this.system_.getVRM() < 328448 || n == -1 ? -1.0f : (float)n / 10.0f;
    }

    public float getPercentSystemASPUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 52) / 10000.0f;
    }

    public float getPercentTemporaryAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 44) / 1000.0f;
    }

    public float getPercentTemporary256MBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 112) / 1000.0f;
    }

    public float getPercentTemporary4GBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 116) / 1000.0f;
    }

    public float getPercentUncappedCPUCapacityUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int n = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 132);
        return this.system_.getVRM() < 328448 || n == -1 ? -1.0f : (float)n / 10.0f;
    }

    public int getPoolsNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(3);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 32);
    }

    public int getProcessorSharingAttribute() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return this.receiverVariables_[2][92] & 0xF;
    }

    public boolean getRestrictedStateFlag() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return this.receiverVariables_[2][30] == -15;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public int getSystemASP() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 48);
    }

    public String getSystemName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(0);
        Converter converter = new Converter(this.system_.getJobCcsid(), this.system_);
        return converter.byteArrayToString(this.receiverVariables_[0], 16, 8).trim();
    }

    public Enumeration getSystemPools() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(3);
        if (this.poolsVector_ != null) {
            return this.poolsVector_.elements();
        }
        this.poolsVector_ = new Vector();
        int n = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 32);
        int n2 = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 36);
        int n3 = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 40);
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.receiverVariables_[3], n2, byArray, 0, n3);
            SystemPool systemPool = null;
            int n4 = BinaryConverter.byteArrayToInt(byArray, 0);
            if (n4 != 0) {
                systemPool = new SystemPool(this.system_, n4);
            } else {
                String string = new CharConverter(this.system_.getJobCcsid(), this.system_).byteArrayToString(byArray, 44, 10);
                systemPool = new SystemPool(this.system_, string);
            }
            this.poolsVector_.addElement(systemPool);
            n2 += n3;
        }
        return this.poolsVector_.elements();
    }

    private synchronized AS400Timestamp getTimestampConverter(int n) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(n);
        } else if (n != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(n);
        }
        return this.timestampConverter_;
    }

    public int getTotalAuxiliaryStorage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 56);
    }

    public int getUsersCurrentSignedOn() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 24);
    }

    public int getUsersSignedOffWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 40);
    }

    public int getUsersSuspendedByGroupJobs() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 36);
    }

    public int getUsersSuspendedBySystemRequest() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 32);
    }

    public int getUsersTemporarilySignedOff() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 28);
    }

    public boolean isCaching() {
        return this.caching_;
    }

    private void loadInformation(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean bl;
        if (!this.caching_) {
            this.refreshCache();
        }
        if (this.receiverVariables_[n] != null) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        if (!this.connected_) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.connected_ = true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving system status.");
        }
        int n2 = n == 1 ? 80 : (n == 2 ? 148 : 2048);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(new byte[]{-30, -30, -29, -30, -16, (byte)(0xF0 | n), -16, -16}), new ProgramParameter(new byte[]{92, -43, -42, 64, 64, 64, 64, 64, 64, 64}), ERROR_CODE};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QWCRSSTS.PGM", programParameterArray);
        do {
            bl = false;
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            this.receiverVariables_[n] = programParameterArray[0].getOutputData();
            int n3 = BinaryConverter.byteArrayToInt(this.receiverVariables_[n], 0);
            int n4 = BinaryConverter.byteArrayToInt(this.receiverVariables_[n], 4);
            if (n4 >= n3) continue;
            bl = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieve system status receiver variable too small, bytes returned: " + n4 + ", bytes available: " + n3);
            }
            programParameterArray[0] = new ProgramParameter(n3);
            programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        } while (bl);
        this.receiverVariables_[0] = this.receiverVariables_[n];
    }

    public void refreshCache() {
        this.receiverVariables_ = new byte[4][];
        this.poolsVector_ = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setCaching(boolean bl) {
        this.caching_ = bl;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }
}

