/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400ListModel;
import com.ibm.as400.vaccess.DoubleClickAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class AS400ListPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    boolean allowActions_ = false;
    boolean confirm_ = true;
    JList list_ = null;
    AS400ListModel model_ = new AS400ListModel();
    private transient VActionContext actionContext_;
    private transient DoubleClickAdapter doubleClickAdapter_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400ListPane() {
        this.list_ = new JList(this.model_);
        this.list_.setCellRenderer(new VObjectCellRenderer());
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.list_));
        this.initializeTransient();
    }

    public AS400ListPane(VNode vNode) {
        this();
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(vNode);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public ListModel getModel() {
        return this.model_;
    }

    public VNode getRoot() {
        return this.model_.getRoot();
    }

    public VObject getSelectedObject() {
        VObject vObject = null;
        int n = this.list_.getSelectedIndex();
        if (n >= 0) {
            vObject = (VObject)this.model_.getElementAt(n);
        }
        return vObject;
    }

    public VObject[] getSelectedObjects() {
        int[] nArray = this.list_.getSelectedIndices();
        int n = nArray.length;
        VObject[] vObjectArray = new VObject[n];
        for (int i = 0; i < n; ++i) {
            vObjectArray[i] = (VObject)this.model_.getElementAt(nArray[i]);
        }
        return vObjectArray;
    }

    public ListSelectionModel getSelectionModel() {
        return this.list_.getSelectionModel();
    }

    public int getVisibleRowCount() {
        return this.list_.getVisibleRowCount();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.list_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.list_));
        VPane_ vPane_ = new VPane_();
        this.doubleClickAdapter_ = new DoubleClickAdapter(vPane_, this.actionContext_);
        this.popupMenuAdapter_ = new PopupMenuAdapter(vPane_, this.actionContext_);
    }

    public boolean isSelected(VObject vObject) {
        if (vObject == null) {
            throw new NullPointerException("object");
        }
        Object[] objectArray = this.list_.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if ((VObject)objectArray[i] != vObject) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.list_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAllowActions(boolean bl) {
        if (this.allowActions_ != bl) {
            this.allowActions_ = bl;
            if (this.allowActions_) {
                this.list_.addMouseListener(this.popupMenuAdapter_);
                this.list_.addMouseListener(this.doubleClickAdapter_);
            } else {
                this.list_.removeMouseListener(this.popupMenuAdapter_);
                this.list_.removeMouseListener(this.doubleClickAdapter_);
            }
        }
    }

    public void setConfirm(boolean bl) {
        this.confirm_ = bl;
    }

    public void setRoot(VNode vNode) throws PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        this.list_.clearSelection();
        this.model_.setRoot(vNode);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.list_.getSelectionModel();
        listSelectionModel2.removeListSelectionListener(this.listSelectionEventSupport_);
        this.list_.setSelectionModel(listSelectionModel);
        listSelectionModel.addListSelectionListener(this.listSelectionEventSupport_);
    }

    public void setVisibleRowCount(int n) {
        this.list_.setVisibleRowCount(n);
    }

    public void sort(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
        this.model_.sort(objectArray, blArray);
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        public boolean getConfirm() {
            return AS400ListPane.this.confirm_;
        }

        public Frame getFrame() {
            return VUtilities.getFrame(AS400ListPane.this);
        }

        public CellEditor startEditing(VObject vObject, Object object) {
            if (vObject == null) {
                throw new NullPointerException("object");
            }
            if (object == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            return null;
        }
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        public VObject getObjectAt(Point point) {
            VObject vObject = null;
            int n = AS400ListPane.this.list_.locationToIndex(point);
            if (n != -1) {
                vObject = (VObject)AS400ListPane.this.model_.getElementAt(n);
            }
            return vObject;
        }

        public VNode getRoot() {
            return AS400ListPane.this.getRoot();
        }

        public void setRoot(VNode vNode) throws PropertyVetoException {
            AS400ListPane.this.setRoot(vNode);
        }
    }
}

